/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.IntRange;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.entities.BombEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BakudanAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bakudan", new Pair[]{ImmutablePair.of((Object)"Throws a bunch of bombs near the user, when enemies come in close proximity with these bombs they'll explode.", null)});
    private static final int COOLDOWN = 200;
    private static final int RANGE = 15;
    public static final TargetsPredicate TARGET_TEST = new TargetsPredicate().testEnemyFaction().testSimpleInView();
    public static final AbilityCore<BakudanAbility> INSTANCE = new AbilityCore.Builder<BakudanAbility>("Bakudan", AbilityCategory.STYLE, BakudanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(15.0f, RangeComponent.RangeType.AOE)).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private IntRange amount = new IntRange(5, 7);

    public BakudanAbility(AbilityCore<BakudanAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM, 7);
        int amount = (int)WyHelper.randomWithRange(entity.func_70681_au(), this.amount.getMin(), this.amount.getMax());
        for (int i = 0; i < amount; ++i) {
            BombEntity bomb = new BombEntity(entity.field_70170_p, entity);
            BlockPos pos = WyHelper.findValidGroundLocation((Entity)entity, entity.func_233580_cy_(), 15, 7);
            if (pos == null) continue;
            bomb.func_70012_b(pos.func_177958_n(), (float)pos.func_177956_o() + 1.5f, pos.func_177952_p(), entity.func_70681_au().nextInt(360), 0.0f);
            entity.field_70170_p.func_217376_c((Entity)bomb);
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    public void setAmount(int amount) {
        this.setAmount(amount, amount);
    }

    public void setAmount(int min, int max) {
        this.amount = new IntRange(min, max);
    }
}

