/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class ChargedCleaveAbility
extends Ability {
    private static final int CHARGE_TIME = 10;
    private static final int COOLDOWN = 100;
    private static final float DAMAGE = 20.0f;
    private static final int RANGE = 5;
    public static final AbilityCore<ChargedCleaveAbility> INSTANCE = new AbilityCore.Builder<IAbility>("Charged Cleave", AbilityCategory.STYLE, ChargedCleaveAbility::new).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), ChargeComponent.getTooltip(10.0f), RangeComponent.getTooltip(5.0f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addEndEvent(this::stopChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final DealDamageComponent damageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private int bleedingPower = 0;
    private int bleedingTime = 40;

    public ChargedCleaveAbility(AbilityCore<ChargedCleaveAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.animationComponent, this.damageComponent, this.rangeComponent);
        this.addCanUseCheck(AbilityHelper::canUseWeaponAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    public void setBleedingPower(int power) {
        this.bleedingPower = power;
    }

    public void setBleedingTime(int time) {
        this.bleedingTime = time;
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 10.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
        this.animationComponent.start(entity, ModAnimations.CHARGE_CLEAVE);
    }

    private void stopChargeEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 5.0f, 2.0f);
        for (LivingEntity target : targets) {
            if (!this.damageComponent.hurtTarget(entity, target, 20.0f)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), this.bleedingTime, this.bleedingPower));
            Vector3d dirVec = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(2.5, 1.0, 2.5);
            target.func_213293_j(dirVec.field_72450_a, 0.2, dirVec.field_72449_c);
            target.field_70133_I = true;
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }
}

