/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.awt.Color;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.AttackCommandGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.FollowCommandGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.GuardCommandGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.StayCommandGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.CommandMarkParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class CommandAbility<E extends MobEntity>
extends Ability {
    private static final int COOLDOWN = 10;
    private static final float RANGE = 20.0f;
    private static final int LIMIT = 20;
    private static final float ATTACK_RAYTRACE_DISTANCE = 30.0f;
    private static final float ATTACK_RAYTRACE_WIDTH = 1.6f;
    private static final int[] COMMAND_COLORS = new int[]{Color.WHITE.getRGB(), Color.RED.getRGB(), Color.GREEN.getRGB(), Color.YELLOW.getRGB(), Color.BLUE.getRGB()};
    private static final TranslationTextComponent IDLE_COMMAND_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.idle_command", "Command: Idle"));
    private static final TranslationTextComponent ATTACK_COMMAND_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.attack_command", "Command: Attack"));
    private static final TranslationTextComponent FOLLOW_COMMAND_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.follow_command", "Command: Follow"));
    private static final TranslationTextComponent STAY_COMMAND_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.stay_command", "Command: Stay"));
    private static final TranslationTextComponent GUARD_COMMAND_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.guard_command", "Command: Guard"));
    private static final TranslationTextComponent[] COMMAND_NAMES = new TranslationTextComponent[]{IDLE_COMMAND_NAME, ATTACK_COMMAND_NAME, FOLLOW_COMMAND_NAME, STAY_COMMAND_NAME, GUARD_COMMAND_NAME};
    private static final ResourceLocation IDLE_ICON = new ResourceLocation("mineminenomi", "textures/abilities/idle_command.png");
    private static final ResourceLocation ATTACK_ICON = new ResourceLocation("mineminenomi", "textures/abilities/attack_command.png");
    private static final ResourceLocation FOLLOW_ICON = new ResourceLocation("mineminenomi", "textures/abilities/follow_command.png");
    private static final ResourceLocation STAY_ICON = new ResourceLocation("mineminenomi", "textures/abilities/stay_command.png");
    private static final ResourceLocation GUARD_ICON = new ResourceLocation("mineminenomi", "textures/abilities/guard_command.png");
    private static final ResourceLocation[] COMMAND_ICONS = new ResourceLocation[]{IDLE_ICON, ATTACK_ICON, FOLLOW_ICON, STAY_ICON, GUARD_ICON};
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "command", new Pair[]{ImmutablePair.of((Object)"Sends a command to all nearby entities that the player has control over.", null), ImmutablePair.of((Object)"  \u00a7aIDLE\u00a7r removes any previously issued command from all nearby entities", null), ImmutablePair.of((Object)"  \u00a7aATTACK\u00a7r either start attacking the entity the player is looking at (if any) or the closest one", null), ImmutablePair.of((Object)"  \u00a7aFOLLOW\u00a7r will start following the command sender", null), ImmutablePair.of((Object)"  \u00a7aSTAY\u00a7r will stay in place, attacking only after being hit first", null), ImmutablePair.of((Object)"  \u00a7aGUARD\u00a7r wil attack any nearby enemies but then return back to its guarding point", null)});
    public static final AbilityCore<CommandAbility> INSTANCE = new AbilityCore.Builder<IAbility>("Command", "command", AbilityCategory.FACTION, AbilityType.ACTION, CommandAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(10.0f), RangeComponent.getTooltip(20.0f, RangeComponent.RangeType.AOE)).setUnlockCheck(CommandAbility::canUnlock).setIcon(IDLE_ICON).build();
    protected final RangeComponent rangeComponent = new RangeComponent(this);
    private final AltModeComponent<NPCCommand> altModeComponent = new AltModeComponent<NPCCommand>(this, NPCCommand.class, NPCCommand.IDLE).addChangeModeEvent(100, this::onChangeModEvent);
    private CommandMarkParticleEffect.Details mainDetails;
    private CommandMarkParticleEffect.Details subDetails;
    private TargetsPredicate targetPredicate = new TargetsPredicate().testFriendlyFaction();
    private NPCCommand command = NPCCommand.IDLE;
    private int markColor = COMMAND_COLORS[0];

    public CommandAbility(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.altModeComponent, this.rangeComponent);
        this.mainDetails = new CommandMarkParticleEffect.Details(this.getMarkColor(), true);
        this.subDetails = new CommandMarkParticleEffect.Details(this.getMarkColor(), false);
        this.addUseEvent(this::onUseEvent);
    }

    public void onUseEvent(LivingEntity entity, IAbility ability) {
        this.targetPredicate.selector(living -> living instanceof MobEntity && living instanceof ICommandReceiver && ((ICommandReceiver)living).canReceiveCommandFrom(entity));
        this.rangeComponent.getTargetsInArea(entity, 20.0f, this.targetPredicate).stream().limit(20L).forEach(target -> {
            this.spawnCommandMark(entity, (LivingEntity)target);
            ((ICommandReceiver)target).setCurrentCommand(entity, this.getCommand());
            this.sendCommand(entity, (MobEntity)target);
        });
        this.spawnCommandMark(entity, entity);
        this.cooldownComponent.startCooldown(entity, 10.0f);
    }

    private void onChangeModEvent(LivingEntity entity, IAbility ability, NPCCommand newCommand) {
        this.command = newCommand;
        this.updateCommandDetails();
    }

    private void updateCommandDetails() {
        this.markColor = COMMAND_COLORS[this.command.ordinal()];
        this.setDisplayName((ITextComponent)COMMAND_NAMES[this.command.ordinal()]);
        this.setDisplayIcon(COMMAND_ICONS[this.command.ordinal()]);
        this.mainDetails = new CommandMarkParticleEffect.Details(this.getMarkColor(), true);
        this.subDetails = new CommandMarkParticleEffect.Details(this.getMarkColor(), false);
    }

    private void spawnCommandMark(LivingEntity entity, LivingEntity target) {
        if (entity instanceof ServerPlayerEntity) {
            WyHelper.spawnParticleEffectForOwner((ParticleEffect)ModParticleEffects.COMMAND_MARK.get(), (PlayerEntity)((ServerPlayerEntity)entity), target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_213302_cg(), target.func_226281_cx_(), entity == target ? this.mainDetails : this.subDetails);
        }
    }

    public NPCCommand getCommand() {
        return this.command;
    }

    public int getMarkColor() {
        return this.markColor;
    }

    public void sendCommand(LivingEntity commandSender, E commandListener) {
        switch (this.command) {
            case ATTACK: {
                LivingEntity target = this.rangeComponent.getTargetsInLine(commandSender, 30.0f, 1.6f).stream().findFirst().orElse(null);
                if (target != null && target.func_70089_S()) {
                    commandListener.func_70624_b(target);
                    break;
                }
                this.rangeComponent.getTargetsInArea(commandSender, 30.0f).stream().sorted(TargetHelper.closestComparator(commandSender.func_213303_ch())).findFirst().ifPresent(aoeTarget -> commandListener.func_70624_b(aoeTarget));
                break;
            }
        }
    }

    public static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IDevilFruit dfProps = DevilFruitCapability.get(entity);
        if (props.isMarine() && props.hasMarineRank(FactionHelper.MarineRank.CAPTAIN)) {
            return true;
        }
        if (props.isRevolutionary() && props.hasRevolutionaryRank(FactionHelper.RevolutionaryRank.COMMANDER)) {
            return true;
        }
        if (dfProps.hasDevilFruit(ModAbilities.KAGE_KAGE_NO_MI) || dfProps.hasDevilFruit(ModAbilities.ITO_ITO_NO_MI)) {
            return true;
        }
        return QuestDataCapability.get(player).hasFinishedQuest(ModQuests.COMMAND_TRIAL);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74768_a("command", this.command.ordinal());
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.command = NPCCommand.values()[nbt.func_74762_e("command")];
        this.updateCommandDetails();
    }

    public static void addCommandGoals(MobEntity mob) {
        mob.field_70714_bg.func_75776_a(0, new StayCommandGoal<MobEntity>(mob));
        mob.field_70714_bg.func_75776_a(0, new FollowCommandGoal<MobEntity>(mob));
        mob.field_70714_bg.func_75776_a(0, new GuardCommandGoal<MobEntity>(mob));
        mob.field_70715_bh.func_75776_a(0, new AttackCommandGoal<MobEntity>(mob));
        mob.field_70715_bh.func_75776_a(0, new StayCommandGoal<MobEntity>(mob));
        mob.field_70715_bh.func_75776_a(0, new FollowCommandGoal<MobEntity>(mob));
        mob.field_70715_bh.func_75776_a(0, new GuardCommandGoal<MobEntity>(mob));
    }
}

