/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.PotionPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;

public abstract class EffectImmunityAbility
extends PotionPassiveAbility {
    public static final ImmunityInfo HEAT_RESISTANCES = ((ImmunityInfo)((ImmunityInfo)new ImmunityInfo().addImmunityEffects(new Supplier[]{ModEffects.FROSTBITE, ModEffects.CANDY_STUCK, ModEffects.CANDLE_LOCK})).addResistanceEffect((Supplier<Effect>)ModEffects.FROZEN, 10)).addResistanceEffect((Supplier<Effect>)ModEffects.STICKY, 6);
    private final ImmunityInfo immunityInfo;

    public EffectImmunityAbility(AbilityCore<EffectImmunityAbility> core, ImmunityInfo info) {
        super((AbilityCore)core);
        this.checkPotionEvent = this::checkPotionEvent;
        this.immunityInfo = info;
    }

    private boolean checkPotionEvent(PlayerEntity player, EffectInstance effect) {
        if (AbilityHelper.isAffectedByWater((LivingEntity)player)) {
            return true;
        }
        ArrayList<Supplier<Effect>> immunityEffects = this.immunityInfo.getImmunityEffects();
        ArrayList<Supplier<Effect>> resistanceEffects = this.immunityInfo.getResistanceEffects();
        ArrayList<Integer> resistanceEffectsReduction = this.immunityInfo.getResistanceEffectsReduction();
        if (resistanceEffects.size() > 0) {
            for (int i = 0; i < resistanceEffects.size(); ++i) {
                if (!resistanceEffects.get(i).get().equals(effect.func_188419_a()) || effect.func_76458_c() >= 1) continue;
                int duration = effect.func_76459_b() / resistanceEffectsReduction.get(i);
                if (duration <= 20) {
                    return false;
                }
                ((EffectInstanceMixin)effect).setDuration(duration);
            }
        }
        return !immunityEffects.stream().map(s -> (Effect)s.get()).collect(Collectors.toList()).contains(effect.func_188419_a());
    }

    public static class ImmunityInfo {
        private ArrayList<Supplier<Effect>> immunityEffects = new ArrayList();
        private ArrayList<Supplier<Effect>> resistanceEffects = new ArrayList();
        private ArrayList<Integer> resistanceEffectsReduction = new ArrayList();

        public ImmunityInfo clone() {
            ImmunityInfo info = new ImmunityInfo();
            info.immunityEffects = this.immunityEffects;
            info.resistanceEffects = this.resistanceEffects;
            info.resistanceEffectsReduction = this.resistanceEffectsReduction;
            return info;
        }

        public ImmunityInfo combine(ImmunityInfo other) {
            this.immunityEffects.addAll(other.immunityEffects);
            this.resistanceEffects.addAll(other.resistanceEffects);
            this.resistanceEffectsReduction.addAll(other.resistanceEffectsReduction);
            return this;
        }

        public ArrayList<Supplier<Effect>> getImmunityEffects() {
            return this.immunityEffects;
        }

        public ArrayList<Supplier<Effect>> getResistanceEffects() {
            return this.resistanceEffects;
        }

        public ArrayList<Integer> getResistanceEffectsReduction() {
            return this.resistanceEffectsReduction;
        }

        public <T extends ImmunityInfo> T addImmunityEffects(Effect ... immunityEffects) {
            for (Effect effect : immunityEffects) {
                this.immunityEffects.add(() -> effect);
            }
            return (T)this;
        }

        public <T extends ImmunityInfo> T addImmunityEffects(Supplier<Effect> ... immunityEffects) {
            this.immunityEffects.addAll(Arrays.asList(immunityEffects));
            return (T)this;
        }

        public <T extends ImmunityInfo> T addResistanceEffect(Effect resistanceEffect, int reduction) {
            this.resistanceEffects.add(() -> resistanceEffect);
            this.resistanceEffectsReduction.add(reduction);
            return (T)this;
        }

        public <T extends ImmunityInfo> T addResistanceEffect(Supplier<Effect> resistanceEffect, int reduction) {
            this.resistanceEffects.add(resistanceEffect);
            this.resistanceEffectsReduction.add(reduction);
            return (T)this;
        }

        public <T extends ImmunityInfo> T addLogiaImmunities() {
            this.addResistanceEffect((Supplier<Effect>)ModEffects.MOVEMENT_BLOCKED, 2);
            return (T)this;
        }
    }
}

