/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.entities.HookEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class HookGrabAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "hook_grab", new Pair[]{ImmutablePair.of((Object)"Shoot's the equipped Hook catching the enemy and dragging them towards the user.", null)});
    private static final int COOLDOWN = 240;
    public static final AbilityCore<HookGrabAbility> INSTANCE = new AbilityCore.Builder<HookGrabAbility>("Hook Grab", AbilityCategory.EQUIPMENT, HookGrabAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private LivingEntity grabbedEntity = null;
    private ItemStack hookStack = ItemStack.field_190927_a;
    private Hand hookHand = Hand.MAIN_HAND;
    private HookEntity proj = null;

    public HookGrabAbility(AbilityCore<HookGrabAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.projectileComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(this::canUseCheck);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        boolean hasHookInOffHand;
        this.grabbedEntity = null;
        this.proj = (HookEntity)((Object)this.projectileComponent.getNewProjectile(entity));
        this.proj.onEntityImpactEvent = hit -> {
            this.grabbedEntity = hit;
        };
        ItemStack mainHandStack = entity.func_184614_ca();
        ItemStack offHandStack = entity.func_184614_ca();
        boolean hasHookInMainHand = !mainHandStack.func_190926_b() && mainHandStack.func_77973_b() == ModWeapons.HOOK.get();
        boolean bl = hasHookInOffHand = !offHandStack.func_190926_b() && offHandStack.func_77973_b() == ModWeapons.HOOK.get();
        if (hasHookInMainHand) {
            this.hookStack = entity.func_184614_ca();
            this.hookHand = Hand.MAIN_HAND;
        } else if (hasHookInOffHand) {
            this.hookStack = entity.func_184614_ca();
            this.hookHand = Hand.OFF_HAND;
        }
        entity.func_184611_a(this.hookHand, ItemStack.field_190927_a);
        entity.field_70170_p.func_217376_c((Entity)this.proj);
        this.proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 4.0f, 0.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(this.proj != null && this.proj.func_70089_S() || this.grabbedEntity != null)) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (!(this.grabbedEntity == null || this.grabbedEntity.func_70089_S() && !AbilityHelper.isGuardBlocking(this.grabbedEntity) && entity.func_70685_l((Entity)this.grabbedEntity))) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (this.grabbedEntity != null) {
            if (this.grabbedEntity.func_70032_d((Entity)entity) < 2.0f) {
                this.grabbedEntity.func_213293_j(0.0, 0.0, 0.0);
                this.continuousComponent.stopContinuity(entity);
                return;
            }
            if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
                Vector3d dirVec = this.grabbedEntity.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b();
                this.grabbedEntity.func_213293_j(-dirVec.field_72450_a, -dirVec.field_72448_b, -dirVec.field_72449_c);
                this.grabbedEntity.field_70133_I = true;
                this.grabbedEntity.field_70143_R = 0.0f;
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.proj = null;
        this.grabbedEntity = null;
        entity.func_184611_a(this.hookHand, this.hookStack);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private HookEntity createProjectile(LivingEntity entity) {
        HookEntity proj = new HookEntity(entity.field_70170_p, entity);
        return proj;
    }

    private AbilityUseResult canUseCheck(LivingEntity entity, IAbility ability) {
        boolean hasHookInOffHand;
        IDevilFruit dfProps = DevilFruitCapability.get(entity);
        if (!dfProps.hasDevilFruit(ModAbilities.SUNA_SUNA_NO_MI) && !dfProps.hasDevilFruit(ModAbilities.MOKU_MOKU_NO_MI)) {
            return AbilityUseResult.fail(null);
        }
        ItemStack mainHandStack = entity.func_184614_ca();
        ItemStack offHandStack = entity.func_184614_ca();
        boolean hasHookInMainHand = !mainHandStack.func_190926_b() && mainHandStack.func_77973_b() == ModWeapons.HOOK.get();
        boolean bl = hasHookInOffHand = !offHandStack.func_190926_b() && offHandStack.func_77973_b() == ModWeapons.HOOK.get();
        if (!hasHookInMainHand && !hasHookInOffHand) {
            return AbilityUseResult.fail(null);
        }
        return AbilityUseResult.success();
    }
}

