/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class TakedownKickAbility
extends DropHitAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "takedown_kick", new Pair[]{ImmutablePair.of((Object)"Jumps high in the sky and kicks down any enemies it reaches temporarily stunning them too.", null)});
    private static final UUID COOLDOWN_BONUS_UUID = UUID.fromString("11164ab3-f50d-4f6e-b2a1-3a2ac0c1c895");
    private static final float COOLDOWN = 240.0f;
    private static final float RANGE = 2.5f;
    private static final float DAMAGE = 10.0f;
    public static final AbilityCore<TakedownKickAbility> INSTANCE = new AbilityCore.Builder<TakedownKickAbility>("Takedown Kick", AbilityCategory.STYLE, TakedownKickAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), DealDamageComponent.getTooltip(10.0f), RangeComponent.getTooltip(2.5f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private boolean isFalling;
    @Nullable
    private Entity target;

    public TakedownKickAbility(AbilityCore<TakedownKickAbility> core) {
        super((AbilityCore<? extends DropHitAbility2>)core);
        this.isNew = true;
        this.addComponents(this.dealDamageComponent, this.rangeComponent, this.animationComponent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::onContinuityEnd);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.isFalling = false;
        if (this.target != null) {
            Vector3d speed = this.target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(7.0, 2.5, 7.0);
            entity.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        } else {
            Vector3d speed = entity.func_70040_Z().func_216372_d(4.0, 1.0, 4.0);
            entity.func_213293_j(speed.field_72450_a, 2.25, speed.field_72449_c);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (DevilFruitHelper.getDifferenceToFloor((Entity)entity) > 5.0) {
            boolean targetHurt = false;
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 2.5f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0, false, false));
                target.func_213293_j(entity.func_213322_ci().field_72450_a, -5.0, entity.func_213322_ci().field_72449_c);
                target.field_70133_I = true;
                targetHurt = true;
            }
            if (targetHurt) {
                if (!this.isFalling) {
                    entity.func_213293_j(0.0, 0.0, 0.0);
                    entity.field_70133_I = true;
                    this.isFalling = true;
                }
                this.animationComponent.start(entity, ModAnimations.TAKEDOWN_KICK, 8);
                if (!entity.field_70170_p.field_72995_K) {
                    ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
                }
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.target = null;
        this.animationComponent.stop(entity);
        if (entity instanceof PlayerEntity) {
            this.cooldownComponent.getBonusManager().addBonus(COOLDOWN_BONUS_UUID, "Cooldown Bonus", BonusOperation.ADD, 360.0f);
        }
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    @Override
    public void onLanding(LivingEntity entity) {
        this.continuousComponent.stopContinuity(entity);
    }

    public void setTarget(Entity target) {
        this.target = target;
    }

    public Entity getTarget() {
        return this.target;
    }
}

