/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class WeaponSpinAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "weapon_spin", new Pair[]{ImmutablePair.of((Object)"Spins around hitting all nearby enemies with the held weapon.", null)});
    private static final int HOLD_TIME = 80;
    private static final float COOLDOWN = 240.0f;
    private static final float DAMAGE = 15.0f;
    private static final float RANGE = 6.0f;
    public static final AbilityCore<WeaponSpinAbility> INSTANCE = new AbilityCore.Builder<WeaponSpinAbility>("Weapon Spin", AbilityCategory.STYLE, WeaponSpinAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ContinuousComponent.getTooltip(80.0f), DealDamageComponent.getTooltip(15.0f), RangeComponent.getTooltip(6.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.BLUNT).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::onStartContinuousEvent).addTickEvent(100, this::onTickContinuousEvent).addEndEvent(100, this::onEndContinuousEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public WeaponSpinAbility(AbilityCore<WeaponSpinAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::requiresBluntWeapon);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 80.0f);
    }

    private void onStartContinuousEvent(LivingEntity entity, IAbility ability) {
        ItemStack stack = entity.func_184614_ca();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        this.animationComponent.start(entity, ModAnimations.SPIN_TO_WIN);
    }

    private void onEndContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private void onTickContinuousEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> list = this.rangeComponent.getTargetsInArea(entity, 6.0f);
        for (LivingEntity target : list) {
            this.dealDamageComponent.hurtTarget(entity, target, 15.0f);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 2, false, false));
    }
}

