/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.WeatherBallAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.CoolBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class CoolBallAbility
extends WeatherBallAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "cool_ball", new Pair[]{ImmutablePair.of((Object)"Launch a Cool Ball from your Clima Tact to use for different Tempos", null), ImmutablePair.of((Object)"\u00a7aSHIFT-USE\u00a7r: Loads the ball into the clima tact", null)});
    public static final AbilityCore<CoolBallAbility> INSTANCE = new AbilityCore.Builder<CoolBallAbility>("Cool Ball", AbilityCategory.STYLE, CoolBallAbility::new).addDescriptionLine(DESCRIPTION).setSourceElement(SourceElement.ICE).setUnlockCheck(CoolBallAbility::canUnlock).build();

    public CoolBallAbility(AbilityCore<CoolBallAbility> core) {
        super(core);
        this.isNew = true;
    }

    @Override
    public WeatherBallKind getKind() {
        return WeatherBallKind.COOL;
    }

    @Override
    public ParticleEffect<?> getParticleEffect() {
        return (ParticleEffect)ModParticleEffects.COOL_BALL_CHARGE.get();
    }

    @Override
    public WeatherBallProjectile getWeatherBallEntity(LivingEntity entity, EntityRayTraceResult lookTrace) {
        CoolBallProjectile proj = new CoolBallProjectile(entity.field_70170_p, entity);
        proj.func_70012_b(lookTrace.func_216347_e().func_82615_a(), entity.func_226278_cu_() + (double)entity.func_70047_e() - 0.5, lookTrace.func_216347_e().func_82616_c(), entity.field_70177_z, entity.field_70125_A);
        proj.func_213293_j(0.0, 0.3, 0.0);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_01);
    }
}

