/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.ArtOfWeatherHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherEggProjectile;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WeatherEggAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "weather_egg", new Pair[]{ImmutablePair.of((Object)"Instantly creates a Weather Cloud as if combining a Cool Ball and a Heat Ball", null)});
    private static final float COOLDOWN = 320.0f;
    public static final AbilityCore<WeatherEggAbility> INSTANCE = new AbilityCore.Builder<WeatherEggAbility>("Weather Egg", AbilityCategory.STYLE, WeatherEggAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(WeatherEggAbility::canUnlock).build();

    public WeatherEggAbility(AbilityCore<WeatherEggAbility> core) {
        super(core);
        this.isNew = true;
        this.addCanUseCheck(ArtOfWeatherHelper::needsSorceryClimaTact);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, 1.5);
        WeatherEggProjectile proj = new WeatherEggProjectile(entity.field_70170_p, entity);
        proj.func_70012_b(trace.func_216347_e().func_82615_a(), entity.func_226278_cu_() + (double)entity.func_70047_e() - 0.5, trace.func_216347_e().func_82616_c(), entity.field_70177_z, entity.field_70125_A);
        proj.func_213293_j(0.0, 0.3, 0.0);
        entity.field_70170_p.func_217376_c((Entity)proj);
        this.cooldownComponent.startCooldown(entity, 320.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_04);
    }
}

