/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ChargedTempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.MirageCloneEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.MirageTempoCloudEntity;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class MirageTempo
extends ChargedTempoAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mirage_tempo", new Pair[]{ImmutablePair.of((Object)"Creates several clones of the user", null)});
    public static final AbilityCore<MirageTempo> INSTANCE = new AbilityCore.Builder<MirageTempo>("Mirage Tempo", AbilityCategory.STYLE, AbilityType.PASSIVE, MirageTempo::new).addDescriptionLine(CHARGED_TEMPO_DESCRIPTION).addDescriptionLine(DESCRIPTION).setUnlockCheck(MirageTempo::canUnlock).build();

    public MirageTempo(AbilityCore<MirageTempo> core) {
        super((AbilityCore)core);
    }

    @Override
    public WeatherBallKind[] getTempoOrder() {
        return new WeatherBallKind[]{WeatherBallKind.COOL, WeatherBallKind.COOL, WeatherBallKind.HEAT};
    }

    @Override
    public void useTempo(LivingEntity entity) {
        MirageTempoCloudEntity smokeCloud = new MirageTempoCloudEntity(entity.field_70170_p);
        smokeCloud.setLife(50);
        smokeCloud.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_(), 0.0f, 0.0f);
        smokeCloud.func_213293_j(0.0, 0.0, 0.0);
        smokeCloud.setThrower(entity);
        entity.field_70170_p.func_217376_c((Entity)smokeCloud);
        for (int i = 0; i < 5; ++i) {
            MirageCloneEntity mirageClone = new MirageCloneEntity(entity.field_70170_p);
            mirageClone.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 180.0f, 0.0f);
            mirageClone.setOwner(entity);
            mirageClone.func_70604_c(entity);
            mirageClone.setMaxAliveTicks(300);
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack stack = entity.func_184582_a(slot);
                mirageClone.func_184201_a(slot, stack);
            }
            entity.field_70170_p.func_217376_c((Entity)mirageClone);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_02);
    }
}

