/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.awa;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GoldenHourAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "golden_hour", new Pair[]{ImmutablePair.of((Object)"Spreads bubbles on enemies around, leaving them weakened and immobile", null)});
    private static final float HOLD_TIME = 200.0f;
    private static final float MIN_COOLDOWN = 200.0f;
    private static final float MAX_COOLDOWN = 1200.0f;
    private static final float RANGE = 10.0f;
    public static final AbilityCore<GoldenHourAbility> INSTANCE = new AbilityCore.Builder<GoldenHourAbility>("Golden Hour", AbilityCategory.DEVIL_FRUITS, GoldenHourAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 1200.0f), ContinuousComponent.getTooltip(200.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public GoldenHourAbility(AbilityCore<GoldenHourAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.rangeComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f);
        targets.removeIf(Entity::func_70090_H);
        for (LivingEntity target : targets) {
            if (!target.func_70644_a((Effect)ModEffects.WASHED.get())) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.WASHED.get(), 100, 1));
            }
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GOLDEN_HOUR.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f + this.continuousComponent.getContinueTime() * 5.0f);
    }
}

