/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.awa;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class SoapDefenseAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "soap_defense", new Pair[]{ImmutablePair.of((Object)"Protect yourself using a giant concentrated soap shield", null)});
    private static final float HOLD_TIME = 200.0f;
    private static final float MIN_COOLDOWN = 50.0f;
    private static final float MAX_COOLDOWN = 250.0f;
    public static final AbilityCore<SoapDefenseAbility> INSTANCE = new AbilityCore.Builder<SoapDefenseAbility>("Soap Defense", AbilityCategory.DEVIL_FRUITS, SoapDefenseAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(50.0f, 250.0f), ContinuousComponent.getTooltip(200.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);

    public SoapDefenseAbility(AbilityCore<SoapDefenseAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.damageTakenComponent, this.poolComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.func_70090_H()) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 4, false, false));
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 50.0f + this.continuousComponent.getContinueTime());
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.continuousComponent.isContinuous()) {
            return damage;
        }
        if (damageSource == ModDamageSource.field_180137_b) {
            return 0.0f;
        }
        return damage;
    }
}

