/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bane;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.bane.SpringHopperAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class SpringSnipeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "spring_snipe", new Pair[]{ImmutablePair.of((Object)"Turning the user's forelegs into springs, they can launch themselves directly at the opponent", null)});
    private static final int CHARGE_TIME = 10;
    private static final int COOLDOWN = 280;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 50.0f;
    public static final AbilityCore<SpringSnipeAbility> INSTANCE = new AbilityCore.Builder<SpringSnipeAbility>("Spring Snipe", AbilityCategory.DEVIL_FRUITS, SpringSnipeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(280.0f), ChargeComponent.getTooltip(10.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(50.0f)).setSourceType(SourceType.PHYSICAL).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuousEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);

    public SpringSnipeAbility(AbilityCore<SpringSnipeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.hitTrackerComponent, this.continuousComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 10.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        SpringHopperAbility springHopper = abilityDataProps.getEquippedAbility(SpringHopperAbility.INSTANCE);
        if (springHopper == null || springHopper.canUse(entity).isFail()) {
            return;
        }
        springHopper.getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> {
            if (!comp.isContinuous()) {
                comp.startContinuity(entity);
            }
        });
        this.hitTrackerComponent.clearHits();
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_213293_j(0.0, 0.0, 0.0);
        entity.field_70133_I = true;
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 10.0f);
        this.animationComponent.start(entity, ModAnimations.SHOOT_SELF_FORWARD);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        Vector3d speed = entity.func_70040_Z().func_216372_d(6.0, 6.0, 6.0);
        entity.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        entity.field_70133_I = true;
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.6f, 1.25f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 50.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 280.0f);
    }
}

