/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bara;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BaraBaraCarAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bara_bara_car", new Pair[]{ImmutablePair.of((Object)"Turns the user's body into a car.", null)});
    private static final int HOLD_TIME = 1200;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 1200;
    private static final float MAX_SPEED = 1.0f;
    private static final float SLIDE_POWER = 1.3f;
    public static final AbilityCore<BaraBaraCarAbility> INSTANCE = new AbilityCore.Builder<BaraBaraCarAbility>("Bara Bara Car", AbilityCategory.DEVIL_FRUITS, BaraBaraCarAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 1200.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Bara Bara Car Speed Modifier", 1.2, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityAttributeModifier STEP_HEIGHT = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Bara Bara Car Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.BARA_ABILITY, new AbilityPool2[0]);

    public BaraBaraCarAbility(AbilityCore<BaraBaraCarAbility> core) {
        super(core);
        super.addComponents(this.poolComponent);
        this.continuousComponent.addTickEvent(this::duringContinuityEvent);
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT);
        this.addCanUseCheck(BaraHelper::hasLimbs);
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.BARA_CAR.get();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_233570_aj_() && entity.func_70051_ag() && (Math.abs(entity.func_213322_ci().func_82615_a()) < 0.2 || Math.abs(entity.func_213322_ci().func_82616_c()) < 0.2)) {
            double x = MathHelper.func_151237_a((double)(entity.func_213322_ci().func_82615_a() * (double)1.3f), (double)-1.0, (double)1.0);
            double z = MathHelper.func_151237_a((double)(entity.func_213322_ci().func_82616_c() * (double)1.3f), (double)-1.0, (double)1.0);
            entity.func_213293_j(x, entity.func_213322_ci().func_82617_b(), z);
        }
    }

    @Override
    public float getContinuityHoldTime() {
        return WyHelper.secondsToTicks(60.0f);
    }

    @Override
    public float getCooldownTicks() {
        return Math.max(100.0f, this.continuousComponent.getContinueTime());
    }
}

