/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bara;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bara.BaraFestivalEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class BaraBaraFestivalAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bara_bara_festival", new Pair[]{ImmutablePair.of((Object)"Splits the user's body in several small parts that constantly hurt and slow down the target.", null), ImmutablePair.of((Object)"Splits the user's body in several small parts that swarm around the user acting as a shield.", null)});
    private static final ITextComponent ATTACK_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.bara_bara_festival", "Bara Bara Festival: Attack"));
    private static final ITextComponent SHIELD_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.bara_bara_festival_shield", "Bara Bara Festival: Shield"));
    private static final ResourceLocation BARA_BARA_FESTIVAL_ATTACK_ICON = new ResourceLocation("mineminenomi", "textures/abilities/bara_bara_festival.png");
    private static final ResourceLocation BARA_BARA_FESTIVAL_SHIELD_ICON = new ResourceLocation("mineminenomi", "textures/abilities/bara_bara_festival_shield.png");
    private static final int COOLDOWN = 300;
    private static final int HOLD_TIME = 160;
    private static final int RANGE = 3;
    private static final int DAMAGE_ATTACK = 6;
    private static final int DAMAGE_SHIELD = 4;
    public static final AbilityCore<BaraBaraFestivalAbility> INSTANCE = new AbilityCore.Builder<BaraBaraFestivalAbility>("Bara Bara Festival", AbilityCategory.DEVIL_FRUITS, BaraBaraFestivalAbility::new).addAdvancedDescriptionLine(CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip(160.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(ATTACK_NAME)), AbilityDescriptionLine.IDescriptionLine.of(DESCRIPTION[0]), DealDamageComponent.getTooltip(6.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(SHIELD_NAME)), AbilityDescriptionLine.IDescriptionLine.of(DESCRIPTION[1]), RangeComponent.getTooltip(3.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(4.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private static final AbilityAttributeModifier STEP_HEIGHT = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Bara Bara Festival Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::continuityStart).addTickEvent(this::continuityTick).addEndEvent(this::continuityEnd);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.ATTACK).addChangeModeEvent(this::altModeChange);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private final GrabEntityComponent grabEntityComponent = new GrabEntityComponent(this, false, false, 0.0f);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final MorphComponent morphComponent = new MorphComponent(this);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private Interval hurtInterval = new Interval(20);
    private BaraFestivalEntity baraFestivalEntity;

    public BaraBaraFestivalAbility(AbilityCore<BaraBaraFestivalAbility> core) {
        super(core);
        this.isNew = true;
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT);
        this.addComponents(this.continuousComponent, this.altModeComponent, this.changeStatsComponent, this.grabEntityComponent, this.dealDamageComponent, this.rangeComponent, this.morphComponent, this.poolComponent);
        this.addCanUseCheck(BaraHelper::hasLimbs);
        this.addUseEvent(this::useEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.ATTACK) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 12.0);
            if (!(mop instanceof EntityRayTraceResult)) {
                entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NO_TARGET, new Object[]{this.getName()}), Util.field_240973_b_);
                return;
            }
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)mop;
            if (entityRayTraceResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entityRayTraceResult.func_216348_a();
                if (!target.func_70089_S() || DevilFruitCapability.get(target).isLogia() && !HakiHelper.hasHardeningActive(entity) || AbilityHelper.isTargetBlocking(entity, target)) {
                    return;
                }
                this.grabEntityComponent.grabManually(entity, target);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.SHIELD) {
            this.grabEntityComponent.grabManually(entity, entity);
        }
        if (!this.grabEntityComponent.hasGrabbedEntity()) {
            entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NO_TARGET, new Object[]{this.getName()}), Util.field_240973_b_);
            return;
        }
        this.continuousComponent.startContinuity(entity, 160.0f);
    }

    private void continuityStart(LivingEntity entity, IAbility ability) {
        if (this.grabEntityComponent.hasGrabbedEntity()) {
            this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.BARA_FESTIVAL.get());
            this.changeStatsComponent.applyModifiers(entity);
            LivingEntity target = this.grabEntityComponent.getGrabbedEntity();
            this.baraFestivalEntity = new BaraFestivalEntity(entity.field_70170_p);
            this.baraFestivalEntity.func_70012_b(target.func_226277_ct_(), target.func_226278_cu_() + 1.0, target.func_226281_cx_(), 0.0f, 0.0f);
            this.baraFestivalEntity.setTarget(target);
            this.baraFestivalEntity.setOwner(entity.func_110124_au());
            entity.field_70170_p.func_217376_c((Entity)this.baraFestivalEntity);
        }
    }

    private void continuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.ATTACK) {
            LivingEntity target = this.grabEntityComponent.getGrabbedEntity();
            if (target == null || !target.func_70089_S() || entity.func_70068_e((Entity)target) > 1500.0) {
                this.continuousComponent.stopContinuity(entity);
                return;
            }
            if (this.hurtInterval.canTick() && this.dealDamageComponent.hurtTarget(entity, target, 6.0f)) {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, 1));
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.SHIELD) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 3.0f);
            for (LivingEntity target : targets) {
                if (!this.dealDamageComponent.hurtTarget(entity, target, 4.0f)) continue;
                Vector3d dist = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72441_c(0.0, -1.0, 0.0).func_72432_b();
                double power = 2.0;
                double xSpeed = -dist.field_72450_a * power;
                double zSpeed = -dist.field_72449_c * power;
                target.func_213293_j(-xSpeed, (double)0.2f, -zSpeed);
                target.field_70133_I = true;
            }
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), 5, 0));
    }

    private void continuityEnd(LivingEntity entity, IAbility ability) {
        if (this.baraFestivalEntity != null) {
            this.baraFestivalEntity.func_70106_y();
        }
        this.changeStatsComponent.removeModifiers(entity);
        this.grabEntityComponent.release(entity);
        this.morphComponent.stopMorph(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private void altModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.ATTACK) {
            this.setDisplayName(ATTACK_NAME);
            this.setDisplayIcon(BARA_BARA_FESTIVAL_ATTACK_ICON);
        } else if (mode == Mode.SHIELD) {
            this.setDisplayName(SHIELD_NAME);
            this.setDisplayIcon(BARA_BARA_FESTIVAL_SHIELD_ICON);
        }
    }

    public static enum Mode {
        ATTACK,
        SHIELD;

    }
}

