/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.beta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BetaCoatingAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "beta_coating", new Pair[]{ImmutablePair.of((Object)"Covers the user in a thick mucus coat, which makes them immune to almost all attacks, but extremely vulnerable to fire.", null)});
    private static final int HOLD_TIME = 800;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 400;
    public static final AbilityCore<BetaCoatingAbility> INSTANCE = new AbilityCore.Builder<BetaCoatingAbility>("Beta Coating", AbilityCategory.DEVIL_FRUITS, BetaCoatingAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 400.0f), ContinuousComponent.getTooltip(800.0f)).build();
    private static final ArrayList<DamageSource> EXPLOSIVE_SOURCES = new ArrayList<DamageSource>(Arrays.asList(DamageSource.field_76372_a, DamageSource.field_180137_b, DamageSource.field_76370_b, DamageSource.field_76371_c));
    private static final ArrayList<SourceElement> EXPLOSIVE_ELEMENTS = new ArrayList<SourceElement>(Arrays.asList(SourceElement.FIRE, SourceElement.LIGHTNING, SourceElement.EXPLOSION));
    private static final AbilityAttributeModifier SPEED_MULTIPLIER = new AbilityAttributeModifier(UUID.fromString("efa08cbd-57e5-478f-b15c-6295eb1b375e"), INSTANCE, "Beta Speed Modifier", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.BETA_COATING).setColor(WyHelper.hexToRGB("#FFFFFFA6")).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private boolean exploded = false;

    public BetaCoatingAbility(AbilityCore<BetaCoatingAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.skinOverlayComponent, this.damageTakenComponent, this.changeStatsComponent);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MULTIPLIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 800.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.exploded = false;
        this.skinOverlayComponent.showAll(entity);
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 10.0f == 0.0f) {
            this.checkIfOnFire(entity);
        }
        this.climbingMovement(entity);
    }

    private void climbingMovement(LivingEntity entity) {
        boolean isNearBlock = false;
        AxisAlignedBB bb = entity.func_174813_aQ().func_72314_b(0.25, 0.25, 0.25);
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    mutpos.func_181079_c(x2, y2, z2);
                    if (entity.field_70170_p.func_180495_p((BlockPos)mutpos).func_185904_a().func_76220_a()) {
                        isNearBlock = true;
                        break;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        if (entity.field_70123_F && !entity.field_70124_G || entity.func_213453_ef() && isNearBlock) {
            double climbSpeed = Math.min(0.1, entity.func_70040_Z().field_72448_b * 0.5);
            if (entity.func_213453_ef()) {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
            } else {
                entity.func_213293_j(entity.func_213322_ci().field_72450_a, climbSpeed, entity.func_213322_ci().field_72449_c);
            }
            entity.field_70143_R = 0.0f;
        }
    }

    private void checkIfOnFire(LivingEntity entity) {
        boolean hasFireAbilityActive = false;
        IAbilityData props = AbilityDataCapability.get(entity);
        for (IAbility abl : props.getEquippedAbilities()) {
            if (!abl.getCore().getSourceElement().equals((Object)SourceElement.FIRE) && !abl.getCore().getSourceElement().equals((Object)SourceElement.MAGMA)) continue;
            boolean isActive = abl.getComponent(ModAbilityKeys.CONTINUOUS).map(comp -> comp.isContinuous()).orElse(false);
            if (isActive) {
                hasFireAbilityActive = true;
                break;
            }
            isActive = abl.getComponent(ModAbilityKeys.CHARGE).map(comp -> comp.isCharging()).orElse(false);
            if (!isActive) continue;
            hasFireAbilityActive = true;
            break;
        }
        if (entity.func_70027_ad() || hasFireAbilityActive) {
            this.exploded = true;
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
        this.changeStatsComponent.removeModifiers(entity);
        float bonus = 0.0f;
        if (this.exploded) {
            bonus = 600.0f;
            entity.func_70066_B();
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 6.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(true);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(true);
            explosion.setStaticDamage(100.0f);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(6));
            explosion.setDamageEntities(true);
            explosion.doExplosion();
        }
        float cooldown = Math.min(100.0f, this.continuousComponent.getContinueTime() / 2.0f) + bonus;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.isContinuous()) {
            return damage;
        }
        if (damageSource instanceof ModDamageSource) {
            ModDamageSource modSource = (ModDamageSource)damageSource;
            if (modSource.isUnavoidable()) {
                return damage;
            }
            for (SourceElement element : EXPLOSIVE_ELEMENTS) {
                if (modSource.getElement() != element) continue;
                this.exploded = true;
                this.continuousComponent.stopContinuity(entity);
                return damage;
            }
        }
        for (DamageSource s : EXPLOSIVE_SOURCES) {
            if (!damageSource.func_76355_l().equals(s.func_76355_l())) continue;
            this.exploded = true;
            this.continuousComponent.stopContinuity(entity);
            return damage;
        }
        if (damageSource.func_76364_f() instanceof LivingEntity && damageSource.func_76364_f().func_70027_ad()) {
            return damage;
        }
        if (!(damageSource.func_94541_c() || damageSource.func_76347_k() || damageSource.func_151517_h())) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BETA_COATING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            return 0.0f;
        }
        this.exploded = true;
        this.continuousComponent.stopContinuity(entity);
        return damage;
    }
}

