/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.beta;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HanamizuShinkenAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "hanamizu_shinken_shirahadori", new Pair[]{ImmutablePair.of((Object)"Creates a protecting wall of mucus, protecting the user from incoming physical attacks and physical projectiles.", null)});
    private static final int HOLD_TIME = 60;
    private static final int COOLDOWN = 100;
    public static final AbilityCore<HanamizuShinkenAbility> INSTANCE = new AbilityCore.Builder<HanamizuShinkenAbility>("Hanamizu Shinken Shirahadori", AbilityCategory.DEVIL_FRUITS, HanamizuShinkenAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), ContinuousComponent.getTooltip(60.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);

    public HanamizuShinkenAbility(AbilityCore<HanamizuShinkenAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        Vector3d lookVec = entity.func_70040_Z();
        int range = 2;
        double boxSize = 1.2;
        for (int i = 0; i < range * 2; ++i) {
            double distance = (double)i / 2.0;
            Vector3d pos = new Vector3d(entity.func_226277_ct_() + lookVec.field_72450_a * distance, entity.func_226278_cu_() + (double)entity.func_70047_e() + lookVec.field_72448_b * distance, entity.func_226281_cx_() + lookVec.field_72449_c * distance);
            List targets = entity.field_70170_p.func_175674_a((Entity)entity, new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize), target -> target != entity);
            for (Entity target2 : targets) {
                if (target2 instanceof AbilityProjectileEntity) {
                    AbilityProjectileEntity projectile = (AbilityProjectileEntity)target2;
                    if (!projectile.isPhysical()) continue;
                    this.reflectProjectile((Entity)projectile);
                    continue;
                }
                if (!(target2 instanceof ThrowableEntity) && !(target2 instanceof AbstractArrowEntity)) continue;
                this.reflectProjectile(target2);
            }
        }
        if (this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
            lookVec.func_216372_d(2.5, 1.0, 2.5);
            Vector3d particlesPos = entity.func_213303_ch().func_178787_e(lookVec);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HANAMIZU_SHINKEN_SHIRADORI.get(), (Entity)entity, particlesPos.field_72450_a, particlesPos.field_72448_b, particlesPos.field_72449_c);
        }
    }

    private void reflectProjectile(Entity target) {
        target.func_213293_j(-target.func_213322_ci().field_72450_a / 2.0, target.func_213322_ci().field_72448_b, -target.func_213322_ci().field_72449_c / 2.0);
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource instanceof ModDamageSource && ((ModDamageSource)damageSource).isPhysical()) {
            Entity attacker = damageSource.func_76364_f();
            if (attacker != null && attacker instanceof LivingEntity) {
                Vector3d lookVec = entity.func_70040_Z().func_216372_d(4.0, 4.0, 4.0);
                attacker.func_213317_d(lookVec);
                attacker.field_70133_I = true;
            }
            return 0.0f;
        }
        return damage;
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }
}

