/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BienCuitGrillShotAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bien_cuit_grill_shot", new Pair[]{ImmutablePair.of((Object)"A strong kick that launches the user forwards and creates a grill-patterened particle to appear, which sets anyone touching it on fire", null)});
    private static final float COOLDOWN = 400.0f;
    private static final float RANGE = 1.8f;
    private static final float DAMAGE = 30.0f;
    public static final AbilityCore<BienCuitGrillShotAbility> INSTANCE = new AbilityCore.Builder<BienCuitGrillShotAbility>("Bien Cuit: Grill Shot", AbilityCategory.STYLE, BienCuitGrillShotAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), RangeComponent.getTooltip(1.8f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(30.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(BienCuitGrillShotAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::startContinuityEvent).addTickEvent(this::continuousTickEvent).addEndEvent(this::continuousEndsEvent);

    public BienCuitGrillShotAbility(AbilityCore<BienCuitGrillShotAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.dealDamageComponent, this.rangeComponent, this.hitTrackerComponent, this.continuousComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(this::hasDiableJambeActive);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 10.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = entity.func_70040_Z().func_216372_d(3.0, 0.0, 3.0);
        entity.func_213293_j(speed.field_72450_a, 0.3, speed.field_72449_c);
        entity.field_70133_I = true;
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BIEN_CUIT_GRILL_SHOT.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void continuousTickEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.8f);
            targets.remove(entity);
            Vector3d pushSpeed = entity.func_70040_Z().func_216372_d(2.0, 0.0, 2.0);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 30.0f)) continue;
                target.func_213293_j(pushSpeed.field_72450_a, 0.2, pushSpeed.field_72449_c);
                target.field_70133_I = true;
                AbilityHelper.setSecondsOnFireBy((Entity)target, 2, entity);
            }
        }
    }

    private void continuousEndsEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    public AbilityUseResult hasDiableJambeActive(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get(entity);
        DiableJambeAbility diableJambeAbility = props.getEquippedAbility(DiableJambeAbility.INSTANCE);
        if (diableJambeAbility == null || !diableJambeAbility.isContinuous()) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_DIABLE_JAMBE));
        }
        return AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(ModQuests.BLACK_LEG_TRIAL_05);
    }
}

