/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class BlackLegPassiveBonusesAbility
extends PassiveStatBonusAbility {
    private static final UUID BLACK_LEG_ATTACK_BONUS_UUID = UUID.fromString("be5937cc-c1da-4891-9583-cebbab2134d3");
    private static final AttributeModifier BLACK_LEG_ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("aa257b39-effd-43b3-9034-615b21e49038"), "Black Leg Speed Multiplier", (double)0.3f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BLACK_LEG_ATTACK_RANGE_MODIFIER = new AttributeModifier(UUID.fromString("cd7d0526-005b-4ef2-a61f-0e941b0d6e1a"), "Black Leg Range Multiplier", 0.5, AttributeModifier.Operation.ADDITION);
    private static final Predicate<LivingEntity> BLACK_LEG_CHECK = entity -> {
        ItemStack heldItem = entity.func_184614_ca();
        return heldItem.func_190926_b();
    };
    private static final AbilityDescriptionLine.IDescriptionLine<BlackLegPassiveBonusesAbility> TOOLTIP = (entity, ability) -> {
        ITextComponent rangeStatText;
        ITextComponent speedStatText;
        ITextComponent punchStatText;
        ITextComponent[] lines = new ITextComponent[4];
        lines[0] = new StringTextComponent("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_STATS.getString() + "\u00a7r");
        TranslationTextComponent attrName = new TranslationTextComponent(((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_233754_c_());
        float value = (float)ability.getBonus(entity);
        lines[1] = punchStatText = new AbilityStat.Builder((ITextComponent)attrName, value).withSign("+").build().getStatDescription(2);
        attrName = new TranslationTextComponent(Attributes.field_233825_h_.func_233754_c_());
        value = (float)BLACK_LEG_ATTACK_SPEED_MODIFIER.func_111164_d();
        lines[2] = speedStatText = new AbilityStat.Builder((ITextComponent)attrName, value).withSign("+").build().getStatDescription(2);
        attrName = new TranslationTextComponent(((Attribute)ModAttributes.ATTACK_RANGE.get()).func_233754_c_());
        value = (float)BLACK_LEG_ATTACK_RANGE_MODIFIER.func_111164_d();
        lines[3] = rangeStatText = new AbilityStat.Builder((ITextComponent)attrName, value).withSign("+").build().getStatDescription(2);
        StringBuilder sb = new StringBuilder();
        int lineId = 0;
        for (ITextComponent text : lines) {
            boolean hasFollowingLine = lineId++ < lines.length - 1;
            sb.append(text.getString() + (hasFollowingLine ? "\n" : ""));
        }
        return new StringTextComponent(sb.toString());
    };
    public static final AbilityCore<BlackLegPassiveBonusesAbility> INSTANCE = new AbilityCore.Builder<BlackLegPassiveBonusesAbility>("Black Leg Passive Bonuses", AbilityCategory.STYLE, AbilityType.PASSIVE, BlackLegPassiveBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(TOOLTIP).setUnlockCheck(BlackLegPassiveBonusesAbility::canUnlock).build();

    public BlackLegPassiveBonusesAbility(AbilityCore<BlackLegPassiveBonusesAbility> core) {
        super(core);
        this.pushDynamicAttribute((Attribute)ModAttributes.PUNCH_DAMAGE.get(), entity -> this.getModifier((LivingEntity)entity));
        this.pushStaticAttribute(Attributes.field_233825_h_, BLACK_LEG_ATTACK_SPEED_MODIFIER);
        this.pushStaticAttribute((Attribute)ModAttributes.ATTACK_RANGE.get(), BLACK_LEG_ATTACK_RANGE_MODIFIER);
    }

    private AttributeModifier getModifier(LivingEntity entity) {
        double bonus = this.getBonus(entity);
        return new AttributeModifier(BLACK_LEG_ATTACK_BONUS_UUID, "Black Leg Attack Bonus", bonus, AttributeModifier.Operation.ADDITION);
    }

    private double getBonus(LivingEntity entity) {
        return 2.0 + EntityStatsCapability.get(entity).getDoriki() * 4.0E-4;
    }

    private static boolean canUnlock(LivingEntity entity) {
        return EntityStatsCapability.get(entity).isBlackLeg();
    }

    @Override
    public Predicate<LivingEntity> getCheck() {
        return BLACK_LEG_CHECK;
    }
}

