/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class ZenshinKibakuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "zenshin_kibaku", new Pair[]{ImmutablePair.of((Object)"The user creates a massive explosion from their body", null)});
    private static final float CHARGE_TIME = 100.0f;
    private static final float MIN_COOLDOWN = 40.0f;
    private static final float MIAX_COOLDOWN = 140.0f;
    public static final AbilityCore<ZenshinKibakuAbility> INSTANCE = new AbilityCore.Builder<ZenshinKibakuAbility>("Zenshin Kibaku", AbilityCategory.DEVIL_FRUITS, ZenshinKibakuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 140.0f), ChargeComponent.getTooltip(100.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.EXPLOSION).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() > 0.1).addTickEvent(100, this::tickChargeEvent).addEndEvent(100, this::endChargeEvent);
    private final StackComponent stackComponent = new StackComponent(this);
    private int previousPower;

    public ZenshinKibakuAbility(AbilityCore<ZenshinKibakuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.stackComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        int power = (int)(this.chargeComponent.getChargePercentage() * 10.0f);
        if (power != this.previousPower) {
            this.stackComponent.setStacks(entity, this, power);
            this.previousPower = power;
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        float power = this.chargeComponent.getChargePercentage() * 10.0f;
        float cooldown = this.chargeComponent.getChargeTime() + 40.0f;
        if (!entity.field_70170_p.field_72995_K) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), power);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)power));
            explosion.setStaticDamage(power * 12.0f);
            explosion.doExplosion();
        }
        this.stackComponent.setStacks(entity, ability, 0);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

