/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DamageAbsorptionAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "damage_absorption", new Pair[]{ImmutablePair.of((Object)"Allows the user to absorb all the incoming damage granting a damage buff at the end based on the total damage received.", null)});
    private static final UUID DAMAGE_BONUS_UUID = UUID.fromString("9f88f925-1627-4ae8-98e0-6e45c588d70b");
    private static final float HOLD_TIME = 100.0f;
    private static final float COOLDOWN = 300.0f;
    private static final float RANGE = 10.0f;
    public static final AbilityCore<DamageAbsorptionAbility> INSTANCE = new AbilityCore.Builder<DamageAbsorptionAbility>("Damage Absorption", AbilityCategory.STYLE, DamageAbsorptionAbility::new).addDescriptionLine(DESCRIPTION).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::duringContinuityEvent).addEndEvent(100, this::endContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private float prevHealth;
    private int hits;
    private float receivedDamage;

    public DamageAbsorptionAbility(AbilityCore<DamageAbsorptionAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.animationComponent, this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        ModifiableAttributeInstance attr = entity.func_110148_a(Attributes.field_233823_f_);
        if (attr != null) {
            attr.func_188479_b(DAMAGE_BONUS_UUID);
        }
        this.hits = 0;
        this.prevHealth = entity.func_110143_aJ();
        this.receivedDamage = 0.0f;
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0));
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70173_aa % 10 == 0) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0));
        }
        if (entity.func_110143_aJ() < this.prevHealth) {
            ++this.hits;
            this.receivedDamage += this.prevHealth - entity.func_110143_aJ();
            this.prevHealth = entity.func_110143_aJ();
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        ModifiableAttributeInstance attr;
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f);
        for (LivingEntity target : targets) {
            Vector3d dirVec = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(3.5, 1.0, 3.5);
            target.func_213293_j(dirVec.field_72450_a, 0.0, dirVec.field_72449_c);
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BERSERKER_POWERUP.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        if ((attr = entity.func_110148_a(Attributes.field_233823_f_)) != null) {
            attr.func_188479_b(DAMAGE_BONUS_UUID);
            attr.func_233767_b_(this.getModifier());
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private AttributeModifier getModifier() {
        this.receivedDamage = Math.min(this.receivedDamage, 30.0f) / 5.0f;
        return new AttributeModifier(DAMAGE_BONUS_UUID, "Damage Absorption Bonus", (double)this.receivedDamage, AttributeModifier.Operation.ADDITION);
    }

    public int getHits() {
        return this.hits;
    }

    public float getReceivedDamage() {
        return this.receivedDamage;
    }
}

