/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class HakaiHoAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "hakai_ho", new Pair[]{ImmutablePair.of((Object)"The user punches with enough force to create a small explosion damaging all nearby enemies.", null)});
    private static final float COOLDOWN = 240.0f;
    private static final int RANGE = 2;
    private static final int DAMAGE = 20;
    public static final AbilityCore<HakaiHoAbility> INSTANCE = new AbilityCore.Builder<HakaiHoAbility>("Hakai Ho", AbilityCategory.STYLE, HakaiHoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip(), RangeComponent.getTooltip(2.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(HakaiHoAbility::canUnlock).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public HakaiHoAbility(AbilityCore<HakaiHoAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.rangeComponent, this.dealDamageComponent);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 2.0f);
        targets.remove(entity);
        targets.remove(target);
        Vector3d dir = entity.func_70040_Z().func_216372_d(5.0, 0.0, 5.0);
        ModDamageSource newSource = ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).ignore();
        for (LivingEntity aoeTarget : targets) {
            if (!this.dealDamageComponent.hurtTarget(entity, aoeTarget, 20.0f, newSource)) continue;
            aoeTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
            aoeTarget.func_213317_d(aoeTarget.func_213322_ci().func_72441_c(dir.field_72450_a, 0.2, dir.field_72449_c));
            aoeTarget.field_70133_I = true;
        }
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 2.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(false);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
        explosion.setDamageEntities(false);
        explosion.doExplosion();
        AbilityHelper.disableAbilities(target, 100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && abl.getComponent(ModAbilityKeys.POOL).get().containsPool(ModAbilityPools.TEKKAI_LIKE));
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public float getPunchCooldown() {
        return 240.0f;
    }

    @Override
    public float getPunchDamage() {
        return 20.0f;
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBrawler() && questProps.hasFinishedQuest(ModQuests.BRAWLER_TRIAL_04);
    }
}

