/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.brawler.KingPunchProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.brawler.KingPunchChargeParticleEffect;

public class KingPunchAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "king_punch", new Pair[]{ImmutablePair.of((Object)"A punch of exceptionally concentrated strength, capable of releasing an immense amount of air pressure, but needs a long time to fully charge", null)});
    private static final KingPunchChargeParticleEffect PARTICLES = new KingPunchChargeParticleEffect();
    private static final int CHARGE_TIME = 1000;
    private static final float MIN_COOLDOWN = 400.0f;
    private static final float MAX_COOLDOWN = 1400.0f;
    private static final float MIN_DAMAGE = 33.333332f;
    private static final float MAX_DAMAGE = 83.333336f;
    public static final AbilityCore<KingPunchAbility> INSTANCE = new AbilityCore.Builder<KingPunchAbility>("King Punch", AbilityCategory.STYLE, KingPunchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f, 1400.0f), ChargeComponent.getTooltip(1000.0f), DealDamageComponent.getTooltip(33.333332f, 83.333336f)).setSourceHakiNature(SourceHakiNature.SPECIAL).setUnlockCheck(KingPunchAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> comp.getChargePercentage() > 0.2f).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::duringChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private boolean cancelled = false;

    public KingPunchAbility(AbilityCore<KingPunchAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.dealDamageComponent);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 1000.0f);
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        this.cancelled = false;
    }

    private void duringChargingEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70172_ad > 0) {
            this.cancelled = true;
            this.chargeComponent.stopCharging(entity);
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
        if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            PARTICLES.spawn(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.cancelled) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        float chargeTime = this.chargeComponent.getChargeTime();
        KingPunchProjectile proj = new KingPunchProjectile(entity.field_70170_p, entity, this);
        proj.setDamage(chargeTime / 12.0f);
        proj.onBlockImpactEvent = pos -> {
            ExplosionAbility explosion = proj.createExplosion((Entity)entity, entity.field_70170_p, proj.func_226277_ct_(), proj.func_226278_cu_(), proj.func_226281_cx_(), 1.0f + chargeTime / 70.0f);
            explosion.setStaticDamage(0.0f);
            explosion.setExplosionSound(false);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(false);
            explosion.setDamageEntities(false);
            explosion.doExplosion();
        };
        entity.field_70170_p.func_217376_c((Entity)proj);
        proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.0f, 1.0f);
        entity.func_195063_d((Effect)ModEffects.MOVEMENT_BLOCKED.get());
        this.cooldownComponent.startCooldown(entity, chargeTime + 400.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBrawler() && questProps.hasFinishedQuest(ModQuests.BRAWLER_TRIAL_06);
    }
}

