/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.chiyu;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.items.DandelionItem;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KenpopoAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kenpopo", new Pair[]{ImmutablePair.of((Object)"Takes an ally's life force, transforming it into a Dandelion. Dandelions can be eaten for healing", null)});
    private static final float COOLDOWN = 1000.0f;
    public static final AbilityCore<KenpopoAbility> INSTANCE = new AbilityCore.Builder<KenpopoAbility>("Kenpopo", AbilityCategory.DEVIL_FRUITS, KenpopoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1000.0f)).setSourceType(SourceType.FIST).build();

    public KenpopoAbility(AbilityCore<KenpopoAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.hitTriggerComponent.addOnHitEvent(80, this::hitEvent);
    }

    private HitTriggerComponent.HitResult hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        Predicate<Entity> isAllyPredicate = ModEntityPredicates.getFriendlyFactions(entity);
        if (target.func_70660_b(Effects.field_76437_t) != null || !isAllyPredicate.test((Entity)target)) {
            return HitTriggerComponent.HitResult.FAIL;
        }
        float healAmount = target.func_110143_aJ() * 0.25f;
        ItemStack dandelionStack = new ItemStack((IItemProvider)ModItems.DANDELION.get());
        DandelionItem.setHealAmount(dandelionStack, healAmount);
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_191521_c(dandelionStack);
        }
        target.func_70606_j(target.func_110143_aJ() - healAmount);
        target.func_195064_c(new EffectInstance(Effects.field_76437_t, 1800, 0));
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHIYUPOPO.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        return HitTriggerComponent.HitResult.FAIL;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchCooldown() {
        return 1000.0f;
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
    }
}

