/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.chiyu;

import java.util.ArrayList;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.WateringCanItem;

public class TearsAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tears", new Pair[]{ImmutablePair.of((Object)"Each time the user is hurt their Watering Can has a 10% chance of being filled with a tear, which can be drank to heal themselves.", null)});
    public static final AbilityCore<TearsAbility> INSTANCE = new AbilityCore.Builder<TearsAbility>("Tears", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, TearsAbility::new).addDescriptionLine(DESCRIPTION).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.HURT);

    public TearsAbility(AbilityCore<TearsAbility> ability) {
        super(ability);
        super.addComponents(this.damageTakenComponent);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (super.canUse(entity).isFail()) {
            return damage;
        }
        if (!(entity instanceof PlayerEntity)) {
            return damage;
        }
        PlayerEntity player = (PlayerEntity)entity;
        ItemStack wateringCan = null;
        ArrayList inventory = new ArrayList();
        inventory.addAll(player.field_71071_by.field_70462_a);
        inventory.addAll(player.field_71071_by.field_184439_c);
        for (ItemStack element : inventory) {
            if (element == null || element.func_77973_b() != ModItems.WATERING_CAN.get()) continue;
            wateringCan = element;
            break;
        }
        if (wateringCan == null) {
            return damage;
        }
        if (this.random.nextInt(10) == 0) {
            WateringCanItem.alterTearAmount(wateringCan, 1);
        }
        return damage;
    }
}

