/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ColaFuelAbility
extends PassiveAbility2 {
    public static final AbilityCore<ColaFuelAbility> INSTANCE = new AbilityCore.Builder<ColaFuelAbility>("Cola Fuel", AbilityCategory.RACIAL, AbilityType.PASSIVE, ColaFuelAbility::new).setHidden().setUnlockCheck(ColaFuelAbility::canUnlock).build();

    public ColaFuelAbility(AbilityCore<ColaFuelAbility> ability) {
        super(ability);
        if (super.isClientSide()) {
            GaugeComponent gaugeComponent = new GaugeComponent(this, this::renderGauge);
            super.addComponents(gaugeComponent);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderGauge(PlayerEntity player, MatrixStack matrixStack, int posX, int posY, ColaFuelAbility ability) {
        RenderSystem.enableBlend();
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)(posX + 6), (int)(posY - 42), (int)0, (int)52, (int)23, (int)40, (float)0.0f);
        int barHeight = (int)((float)entityStatsProps.getCola() / (float)entityStatsProps.getMaxCola() * 30.0f) + 23;
        if (barHeight > 0 && barHeight < 24) {
            barHeight = 24;
        } else if (barHeight > 52) {
            barHeight = 52;
        }
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)(posX + 10), (int)(posY - 42), (int)32, (int)barHeight, (int)16, (int)32, (float)0.0f);
        String cola = entityStatsProps.getCola() + "";
        WyHelper.drawStringWithBorder(mc.field_71466_p, matrixStack, cola, posX + 18 - mc.field_71466_p.func_78256_a(cola) / 2, posY - 12, Color.WHITE.getRGB());
        RenderSystem.disableBlend();
    }

    private static boolean canUnlock(LivingEntity entity) {
        return EntityStatsCapability.get(entity).isCyborg();
    }
}

