/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateColaAmountPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ColaOverdriveAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "cola_overdrive", new Pair[]{ImmutablePair.of((Object)"The user absorbs half of their cola at once to boost their physical abilities temporarily.", null)});
    private static final float COOLDOWN = 1000.0f;
    private static final AbilityDescriptionLine.IDescriptionLine COLA_TOOLTIP = (e, a) -> {
        IEntityStats props = EntityStatsCapability.get(e);
        int half = (int)Math.floor((float)props.getMaxCola() / 2.0f);
        AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_COLA, half);
        return statBuilder.build().getStatDescription();
    };
    public static final AbilityCore<ColaOverdriveAbility> INSTANCE = new AbilityCore.Builder<ColaOverdriveAbility>("Cola Overdrive", AbilityCategory.RACIAL, ColaOverdriveAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1000.0f), COLA_TOOLTIP).setUnlockCheck(ColaOverdriveAbility::canUnlock).build();

    public ColaOverdriveAbility(AbilityCore<ColaOverdriveAbility> core) {
        super(core);
        this.isNew = true;
        this.addCanUseCheck(this::canStartAbility);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get(entity);
        float half = (float)props.getMaxCola() / 2.0f;
        props.alterCola((int)(-half));
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo(new SUpdateColaAmountPacket(entity), (PlayerEntity)((ServerPlayerEntity)entity));
        }
        int effectPotency = (int)Math.floor((double)half / 150.0);
        int effectDuration = effectPotency * 100;
        entity.func_195064_c(new EffectInstance(Effects.field_76429_m, effectDuration, effectPotency));
        entity.func_195064_c(new EffectInstance(Effects.field_76424_c, effectDuration, effectPotency));
        entity.func_195064_c(new EffectInstance(Effects.field_76420_g, effectDuration, effectPotency));
        this.cooldownComponent.startCooldown(entity, 1000.0f);
    }

    private AbilityUseResult canStartAbility(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get(entity);
        double half = (float)props.getMaxCola() / 2.0f;
        if ((double)props.getCola() - half < 0.0) {
            return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA);
        }
        return AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isCyborg();
    }
}

