/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doa;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class KaitenDoorAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kaiten_door", new Pair[]{ImmutablePair.of((Object)"Turn the head of your opponent into a rotating door to confuse and disorient them.", null)});
    private static final int COOLDOWN = 200;
    public static final AbilityCore<KaitenDoorAbility> INSTANCE = new AbilityCore.Builder<KaitenDoorAbility>("Kaiten Door", AbilityCategory.DEVIL_FRUITS, KaitenDoorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();

    public KaitenDoorAbility(AbilityCore<KaitenDoorAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
    }

    @Override
    public float getPunchDamage() {
        return 4.0f;
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        if (this.canActivate().test(entity)) {
            target.func_195064_c(new EffectInstance(Effects.field_76431_k, 100, 1, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DOOR_HEAD.get(), 100, 0, false, false));
            this.continuousComponent.stopContinuity(entity);
        }
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchCooldown() {
        return 200.0f;
    }
}

