/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HealComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FirstAidAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "first_aid", new Pair[]{ImmutablePair.of((Object)"Heals the target by punching them.", null), ImmutablePair.of((Object)"\u00a7aSHIFT-USE\u00a7r: User injects themselves", null)});
    private static final int COOLDOWN = 300;
    private static final int MIN_HEAL = 5;
    private static final int MAX_HEAL = 50;
    private final HealComponent healComponent = new HealComponent(this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(100, this::hitEvent);
    public static final AbilityCore<FirstAidAbility> INSTANCE = new AbilityCore.Builder<FirstAidAbility>("First Aid", AbilityCategory.STYLE, FirstAidAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), HealComponent.getTooltip(5.0f, 50.0f)).setSourceType(SourceType.FIST).setUnlockCheck(FirstAidAbility::canUnlock).build();

    public FirstAidAbility(AbilityCore<FirstAidAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.hitTriggerComponent, this.healComponent);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addCanUseCheck(AbilityHelper::requiresMedicBag);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private HitTriggerComponent.HitResult hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            boolean hasMedicBag;
            source.setBypassFriendlyDamage();
            ItemStack medicBag = entity.func_184582_a(EquipmentSlotType.CHEST);
            boolean bl = hasMedicBag = !medicBag.func_190926_b() && medicBag.func_77973_b() == ModArmors.MEDIC_BAG.get();
            if (!hasMedicBag) {
                return HitTriggerComponent.HitResult.PASS;
            }
            this.applyFirstAid(entity, target);
            this.continuousComponent.stopContinuity(entity);
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    private void applyFirstAid(LivingEntity entity, LivingEntity target) {
        float heal = (float)MathHelper.func_151237_a((double)WyHelper.percentage(10.0, target.func_110138_aP()), (double)5.0, (double)50.0);
        this.healComponent.healTarget(entity, target, heal);
        target.func_195064_c(new EffectInstance(Effects.field_76428_l, 100, 4));
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FIRST_AID.get(), (Entity)target, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isDoctor() && questProps.hasFinishedQuest(ModQuests.DOCTOR_TRIAL_01);
    }
}

