/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doru;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doru.ChampFightProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doru.DoruDoruArtsMoriProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class DoruDoruArtsMoriAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "doru_doru_arts_mori", new Pair[]{ImmutablePair.of((Object)"The user fires a harpoon made of wax at the opponent", null)});
    private static final TranslationTextComponent CHAMP_FIGHT_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.champ_fight", "Champ Fight"));
    private static final ResourceLocation CHAMP_FIGHT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/champ_fight.png");
    private static final float COOLDOWN = 80.0f;
    public static final AbilityCore<DoruDoruArtsMoriAbility> INSTANCE = new AbilityCore.Builder<DoruDoruArtsMoriAbility>("Doru Doru Arts: Mori", AbilityCategory.DEVIL_FRUITS, DoruDoruArtsMoriAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.WAX).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(100, this::repeaterTriggerEvent).addStopEvent(100, this::repeaterStopEvent);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.MORI).addChangeModeEvent(100, this::changeModeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public DoruDoruArtsMoriAbility(AbilityCore<DoruDoruArtsMoriAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent, this.altModeComponent, this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER);
        if (this.altModeComponent.getCurrentMode() == Mode.CHAMP_FIGHT) {
            this.repeaterComponent.start(entity, 25, 1);
        } else if (this.altModeComponent.getCurrentMode() == Mode.MORI) {
            this.repeaterComponent.start(entity, 1, 0);
        }
    }

    private void repeaterTriggerEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode().equals((Object)Mode.CHAMP_FIGHT)) {
            this.projectileComponent.shootWithSpread(entity, 2.0f, 1.0f, 2);
        } else {
            this.projectileComponent.shoot(entity, 3.0f, 0.0f);
        }
    }

    private void repeaterStopEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 80.0f);
    }

    private void changeModeEvent(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode.equals((Object)Mode.CHAMP_FIGHT)) {
            this.setDisplayIcon(CHAMP_FIGHT_ICON);
            this.setDisplayName((ITextComponent)CHAMP_FIGHT_NAME);
        } else {
            this.setDisplayIcon(INSTANCE);
            this.setDisplayName((ITextComponent)INSTANCE.getLocalizedName());
        }
    }

    public void changeToChampFight(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.CHAMP_FIGHT);
    }

    public void changeToDefault(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.MORI);
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        if (this.altModeComponent.getCurrentMode().equals((Object)Mode.CHAMP_FIGHT)) {
            ChampFightProjectile proj = new ChampFightProjectile(entity.field_70170_p, entity);
            return proj;
        }
        DoruDoruArtsMoriProjectile proj = new DoruDoruArtsMoriProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    public static enum Mode {
        MORI,
        CHAMP_FIGHT;

    }
}

