/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doru;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TokudaiCandleAbility
extends Ability {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).setCoordsOnly().build();
    private static final float COOLDOWN = 6000.0f;
    private static final float HOLD_TIME = 1200.0f;
    private static final int FIRST_LAYER_SIZE = 15;
    private static final int SECOND_LAYER_SIZE = 10;
    private static final int THIRD_LAYER_XZ_SIZE = 5;
    private static final int THIRD_LAYER_Y_SIZE = 10;
    private static final int FOURTH_LAYER_XZ_SIZE = 13;
    private static final int FOURTH_LAYER_Y_SIZE = 10;
    private static final float RANGE = 100.0f;
    public static final AbilityCore<TokudaiCandleAbility> INSTANCE = new AbilityCore.Builder<TokudaiCandleAbility>("Tokudai Candle", AbilityCategory.DEVIL_FRUITS, TokudaiCandleAbility::new).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(100, this::onTickContinuityEvent).addEndEvent(100, this::onEndContinuityEvent);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(100, this::onTickChargeEvent).addEndEvent(100, this::onEndChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private BlockPos centerPos;
    private Vector3d centerPosVec;
    private int blocksPerTick = 200;
    private List<BlockPos> posList = new ArrayList<BlockPos>();
    private List<BlockPos> toPlaceList = new ArrayList<BlockPos>();

    public TokudaiCandleAbility(AbilityCore<TokudaiCandleAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.continuousComponent, this.rangeComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (this.chargeComponent.isCharging()) {
            return;
        }
        if (this.centerPos == null) {
            Vector3d startVec = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
            Vector3d endVec = startVec.func_178787_e(entity.func_70040_Z().func_186678_a(128.0));
            BlockRayTraceResult result = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
            this.setCenterPos(result.func_216350_a());
        }
        if (!this.posList.isEmpty()) {
            this.clearPlacedBlocks(entity.field_70170_p);
        }
        for (LivingEntity target : this.rangeComponent.getTargetsInArea(entity, 100.0f, null)) {
            Vector3d pushVec = target.func_213303_ch().func_178788_d(this.centerPosVec).func_72432_b().func_216372_d(10.0, 1.0, 10.0);
            target.func_213293_j(pushVec.field_72450_a, target.func_213322_ci().field_72448_b, pushVec.field_72449_c);
            target.field_70133_I = true;
        }
        this.blocksPerTick = 100;
        BlockState defaultWaxState = ((Block)ModBlocks.WAX.get()).func_176223_P();
        this.posList.addAll(AbilityHelper.getFilledCubePositions(entity.field_70170_p, this.centerPos.func_177958_n(), this.centerPos.func_177956_o(), this.centerPos.func_177952_p(), 15, 15, 15, defaultWaxState, 0, GRIEF_RULE));
        this.posList.addAll(AbilityHelper.getFilledCubePositions(entity.field_70170_p, this.centerPos.func_177958_n(), this.centerPos.func_177956_o() + 15, this.centerPos.func_177952_p(), 10, 10, 10, defaultWaxState, 0, GRIEF_RULE));
        this.posList.addAll(AbilityHelper.getFilledCubePositions(entity.field_70170_p, this.centerPos.func_177958_n(), this.centerPos.func_177956_o() + 15 + 10, this.centerPos.func_177952_p(), 5, 10, 5, defaultWaxState, 0, GRIEF_RULE));
        this.posList.addAll(AbilityHelper.getFilledSpherePositions(entity.field_70170_p, this.centerPos.func_177958_n(), this.centerPos.func_177956_o() + 15 + 10 + 10 + 6, this.centerPos.func_177952_p(), 13, 10, defaultWaxState, 0, GRIEF_RULE));
        int candleSplitDist = 9;
        Vector3i candleSize = new Vector3i(0, 4, 0);
        BlockPos candle1b = this.centerPos.func_177982_a(13, 15, 13);
        BlockPos candle1t = candle1b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle1b, candle1t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle2b = candle1b.func_177982_a(-9, 0, 0);
        BlockPos candle2t = candle2b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle2b, candle2t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle3b = candle2b.func_177982_a(-9, 0, 0);
        BlockPos candle3t = candle3b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle3b, candle3t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle4b = candle3b.func_177982_a(-9, 0, 0);
        BlockPos candle4t = candle4b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle4b, candle4t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle5b = candle4b.func_177982_a(0, 0, -9);
        BlockPos candle5t = candle5b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle5b, candle5t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle6b = candle5b.func_177982_a(0, 0, -9);
        BlockPos candle6t = candle6b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle6b, candle6t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle7b = candle6b.func_177982_a(0, 0, -9);
        BlockPos candle7t = candle7b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle7b, candle7t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle8b = candle7b.func_177982_a(9, 0, 0);
        BlockPos candle8t = candle8b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle8b, candle8t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle9b = candle8b.func_177982_a(9, 0, 0);
        BlockPos candle9t = candle9b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle9b, candle9t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle10b = candle9b.func_177982_a(9, 0, 0);
        BlockPos candle10t = candle10b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle10b, candle10t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle11b = candle10b.func_177982_a(0, 0, 9);
        BlockPos candle11t = candle11b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle11b, candle11t, defaultWaxState, 3, GRIEF_RULE));
        BlockPos candle12b = candle11b.func_177982_a(0, 0, 9);
        BlockPos candle12t = candle12b.func_177971_a(candleSize);
        this.posList.addAll(StructuresHelper.fillCube(entity.field_70170_p, candle12b, candle12t, defaultWaxState, 3, GRIEF_RULE));
        this.posList = this.posList.stream().distinct().collect(Collectors.toList());
        this.toPlaceList.clear();
        this.toPlaceList.addAll(this.posList);
        float chargeTime = (float)this.posList.size() / (float)this.blocksPerTick;
        this.chargeComponent.startCharging(entity, chargeTime);
    }

    private void onTickChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 5 == 0) {
            Vector3d motion = entity.func_213303_ch().func_178787_e(entity.func_70040_Z().func_216372_d(5.0, 5.0, 5.0)).func_178788_d(this.centerPosVec.func_72441_c(0.0, 10.0, 0.0)).func_72432_b().func_216372_d((double)1.15f, (double)1.15f, (double)1.15f).func_216371_e();
            for (int i = 0; i < 15; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                double offsetMotionX = WyHelper.randomDouble() / 5.0;
                double offsetMotionY = WyHelper.randomDouble() / 5.0;
                double offsetMotionZ = WyHelper.randomDouble() / 5.0;
                SimpleParticleData particle = new SimpleParticleData((ParticleType)ModParticleTypes.MOKU.get());
                particle.setLife(30);
                particle.setSize(3.0f);
                particle.setMotion(motion.field_72450_a + offsetMotionX, motion.field_72448_b + offsetMotionY, motion.field_72449_c + offsetMotionZ);
                WyHelper.spawnParticles(particle, (ServerWorld)entity.field_70170_p, entity.func_226277_ct_() + offsetX, entity.func_226278_cu_() + (double)entity.func_70047_e() + offsetY, entity.func_226281_cx_() + offsetZ);
            }
        }
        Iterator<BlockPos> iter = this.toPlaceList.iterator();
        int placedBlocks = 0;
        while (iter.hasNext()) {
            BlockPos pos = iter.next();
            entity.field_70170_p.func_175656_a(pos, ((Block)ModBlocks.WAX.get()).func_176223_P());
            iter.remove();
            if (++placedBlocks <= this.blocksPerTick) continue;
            return;
        }
    }

    private void onEndChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.centerPos != null) {
            int candleSplitDist = 9;
            BlockPos candle1 = this.centerPos.func_177982_a(13, 20, 13);
            entity.field_70170_p.func_180501_a(candle1, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle2 = candle1.func_177982_a(-9, 0, 0);
            entity.field_70170_p.func_180501_a(candle2, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle3 = candle2.func_177982_a(-9, 0, 0);
            entity.field_70170_p.func_180501_a(candle3, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle4 = candle3.func_177982_a(-9, 0, 0);
            entity.field_70170_p.func_180501_a(candle4, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle5 = candle4.func_177982_a(0, 0, -9);
            entity.field_70170_p.func_180501_a(candle5, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle6 = candle5.func_177982_a(0, 0, -9);
            entity.field_70170_p.func_180501_a(candle6, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle7 = candle6.func_177982_a(0, 0, -9);
            entity.field_70170_p.func_180501_a(candle7, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle8 = candle7.func_177982_a(9, 0, 0);
            entity.field_70170_p.func_180501_a(candle8, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle9 = candle8.func_177982_a(9, 0, 0);
            entity.field_70170_p.func_180501_a(candle9, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle10 = candle9.func_177982_a(9, 0, 0);
            entity.field_70170_p.func_180501_a(candle10, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle11 = candle10.func_177982_a(0, 0, 9);
            entity.field_70170_p.func_180501_a(candle11, Blocks.field_150480_ab.func_176223_P(), 3);
            BlockPos candle12 = candle11.func_177982_a(0, 0, 9);
            entity.field_70170_p.func_180501_a(candle12, Blocks.field_150480_ab.func_176223_P(), 3);
        }
        this.continuousComponent.startContinuity(entity, 1200.0f);
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.TOKUDAI_CANDLE.get(), (Entity)entity, this.centerPos.func_177958_n(), this.centerPos.func_177956_o(), this.centerPos.func_177952_p());
        }
    }

    private void onTickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 100 == 0) {
            for (LivingEntity target : this.rangeComponent.getTargetsInArea(entity, 100.0f, null)) {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 0));
                target.func_195064_c(new EffectInstance(Effects.field_76437_t, 100, 0));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.TOKUDAI_CANDLE_POISON.get(), 100, 0));
            }
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.TOKUDAI_CANDLE.get(), (Entity)entity, this.centerPos.func_177958_n(), this.centerPos.func_177956_o(), this.centerPos.func_177952_p());
        }
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.clearPlacedBlocks(entity.field_70170_p);
        this.centerPos = null;
        this.cooldownComponent.startCooldown(entity, 6000.0f);
    }

    private void clearPlacedBlocks(World level) {
        for (BlockPos pos : this.posList) {
            Block currentBlock = level.func_180495_p(pos).func_177230_c();
            if (currentBlock != ModBlocks.WAX.get()) continue;
            level.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.posList.clear();
    }

    public void setBlocksPerTick(int blocks) {
        this.blocksPerTick = blocks;
    }

    public void setCenterPos(BlockPos centerPos) {
        this.centerPos = centerPos;
        this.centerPosVec = Vector3d.func_237489_a_((Vector3i)centerPos);
    }
}

