/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectroHelper;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.events.passives.MinkPassiveEvents;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElectricalTempestaAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.5f;
    private static final float DAMAGE_BONUS = 2.0f;
    private static final float RANGE_BONUS = 2.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "electrical_tempesta", new Pair[]{ImmutablePair.of((Object)"The user releases a charge of energy that deals damage to nearby enemies and knocks them back.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s, the damage is increased by %s and the range of the ability is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(SulongAbility.INSTANCE), AbilityHelper.mentionText(Math.round(50.0f) + "%"), AbilityHelper.mentionText(Math.round(Math.abs(-1.0f) * 100.0f) + "%"), AbilityHelper.mentionText(Math.round(Math.abs(-1.0f) * 100.0f) + "%")})});
    private static final int COOLDOWN = 160;
    private static final int CHARGE_TIME = 10;
    private static final int RANGE = 10;
    private static final int DAMAGE = 20;
    private static final int ELECLAW_STACKS = 1;
    public static final AbilityCore<ElectricalTempestaAbility> INSTANCE = new AbilityCore.Builder<ElectricalTempestaAbility>("Electrical Tempesta", AbilityCategory.RACIAL, ElectricalTempestaAbility::new).addDescriptionLine(DESCRIPTION[0]).addAdvancedDescriptionLine(AbilityDescriptionLine.IDescriptionLine.of(DESCRIPTION[1])).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ChargeComponent.getTooltip(10.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(ElectricalTempestaAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private LightningDischargeEntity ballEntity = null;

    public ElectricalTempestaAbility(AbilityCore<ElectricalTempestaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.rangeComponent, this.dealDamageComponent);
        this.addCanUseCheck(ElectroHelper.requireEleclaw(1));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 10.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ELECTRO_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        if (this.ballEntity == null) {
            LightningDischargeEntity ball = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
            entity.field_70170_p.func_217376_c((Entity)ball);
            this.ballEntity = ball;
        } else {
            float distance = 0.5f;
            Vector3d lookVec = entity.func_70040_Z();
            double px = entity.func_226277_ct_() + lookVec.field_72450_a * (double)distance;
            double py = entity.func_226278_cu_() + lookVec.field_72450_a * (double)distance;
            double pz = entity.func_226281_cx_() + lookVec.field_72449_c * (double)distance;
            Vector3d pos = new Vector3d(px, py, pz);
            float percentage = 1.0f - this.chargeComponent.getChargeTime() / this.chargeComponent.getMaxChargeTime();
            this.ballEntity.setSize(percentage * 0.1f);
            this.ballEntity.setLightningLength(2.0f);
            this.ballEntity.func_70012_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), entity.field_70177_z, entity.field_70125_A);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean hasSulongActive = ElectroHelper.hasSulongActive(entity);
        this.dealDamageComponent.getBonusManager().removeBonus(ElectroHelper.SULONG_DAMAGE_BONUS);
        this.rangeComponent.getBonusManager().removeBonus(ElectroHelper.SULONG_RANGE_BONUS);
        this.cooldownComponent.getBonusManager().removeBonus(ElectroHelper.SULONG_COOLDOWN_BONUS);
        if (hasSulongActive) {
            this.dealDamageComponent.getBonusManager().addBonus(ElectroHelper.SULONG_DAMAGE_BONUS, "Sulong Damage Bonus", BonusOperation.MUL, 2.0f);
            this.rangeComponent.getBonusManager().addBonus(ElectroHelper.SULONG_RANGE_BONUS, "Sulong Range Bonus", BonusOperation.MUL, 2.0f);
            this.cooldownComponent.getBonusManager().addBonus(ElectroHelper.SULONG_COOLDOWN_BONUS, "Sulong Cooldown Bonus", BonusOperation.MUL, 0.5f);
        }
        if (this.ballEntity != null) {
            this.ballEntity.func_70106_y();
            this.ballEntity = null;
        }
        for (int i = 0; i < 3; ++i) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ELECTRICAL_TEMPESTA_2.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f);
        ModDamageSource source = ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setUnavoidable();
        for (LivingEntity target : targets) {
            if (!this.dealDamageComponent.hurtTarget(entity, target, 20.0f, source)) continue;
            Vector3d dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b();
            target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 10, 0, false, false, true));
            target.func_213293_j(-dirVec.field_72450_a * 4.0, 1.0, -dirVec.field_72449_c * 4.0);
            target.field_70133_I = true;
        }
        float range = this.rangeComponent.getRange();
        int amount = 32;
        for (int j = 0; j < amount; ++j) {
            float boltSize = (float)WyHelper.randomWithRange(3, (int)range);
            LightningEntity bolt = new LightningEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (float)WyHelper.randomWithRange(0, 360), (float)WyHelper.randomWithRange(0, 5), boltSize, 8.0f, this.getCore());
            bolt.setColor(MinkPassiveEvents.MINK_LIGHTNING_COLOR);
            bolt.setAngle(60);
            bolt.setMaxLife(20);
            bolt.setDamage(0.0f);
            bolt.setExplosion(0, false);
            bolt.setSize(boltSize / 600.0f);
            bolt.setBranches((int)WyHelper.randomWithRange(1, 3));
            bolt.setSegments((int)((double)boltSize * 0.6));
            bolt.setLightningMimic(false);
            entity.field_70170_p.func_217376_c((Entity)bolt);
        }
        EleclawAbility eleclaw = AbilityDataCapability.get(entity).getEquippedAbility(EleclawAbility.INSTANCE);
        if (eleclaw != null) {
            eleclaw.reduceUsage(entity, 1);
        }
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isMink() && props.getDoriki() >= 3000.0;
    }
}

