/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class MinkPassiveBonusesAbility
extends PassiveStatBonusAbility {
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("d70f4c72-ba2e-4aaf-8461-8c04d5053367"), "Mink Speed Multiplier", 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier JUMP_MODIFIER = new AttributeModifier(UUID.fromString("592e8290-5c83-4467-a3ec-0ae748d9cdc4"), "Mink Jump Boost Addition", 0.75, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier JUMP_RESISTANCE_MODIFIER = new AttributeModifier(UUID.fromString("d8b7e977-414a-4ca7-b538-063440e503b0"), "Mink Jump Resistance", 1.5, AttributeModifier.Operation.ADDITION);
    private static final Predicate<LivingEntity> TEMPERATURE_CHECK = entity -> {
        boolean temperatureCheck;
        BlockPos position = entity.func_233580_cy_();
        float temperature = (float)Math.round(entity.field_70170_p.func_226691_t_(position).func_225486_c(position) * 10.0f) / 10.0f;
        if (entity.field_70170_p.func_226691_t_(position).func_242445_k() - 0.1f > temperature) {
            temperature = entity.field_70170_p.func_226691_t_(position).func_242445_k() - 0.1f;
        }
        boolean bl = temperatureCheck = (double)temperature < 2.0;
        return temperatureCheck && entity.field_70170_p.func_226691_t_(position).func_201856_r() != Biome.Category.OCEAN;
    };
    public static final AbilityCore<MinkPassiveBonusesAbility> INSTANCE = new AbilityCore.Builder<MinkPassiveBonusesAbility>("Mink Passive Bonuses", AbilityCategory.RACIAL, AbilityType.PASSIVE, MinkPassiveBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(ChangeStatsComponent.getTooltip()).setUnlockCheck(MinkPassiveBonusesAbility::canUnlock).build();

    public MinkPassiveBonusesAbility(AbilityCore<MinkPassiveBonusesAbility> core) {
        super(core);
        this.pushStaticAttribute(Attributes.field_233821_d_, SPEED_MODIFIER);
        this.pushStaticAttribute((Attribute)ModAttributes.JUMP_HEIGHT.get(), JUMP_MODIFIER);
        this.pushStaticAttribute((Attribute)ModAttributes.FALL_RESISTANCE.get(), JUMP_RESISTANCE_MODIFIER);
    }

    @Override
    public Predicate<LivingEntity> getCheck() {
        return TEMPERATURE_CHECK;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get(entity);
        return props.isMink();
    }
}

