/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectroHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SulongAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sulong", new Pair[]{ImmutablePair.of((Object)"The user reveals their true power during the full moon, enhancing their physical and electrical power. While active %s stacks are not consumed.", (Object)new Object[]{AbilityHelper.mentionAbility(EleclawAbility.INSTANCE)})});
    private static final int HOLD_TIME = 300;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 600;
    private static final Color COLOR = WyHelper.hexToRGB("#B0E9F255");
    public static final AbilityCore<SulongAbility> INSTANCE = new AbilityCore.Builder<SulongAbility>("Sulong", AbilityCategory.RACIAL, SulongAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 600.0f), ContinuousComponent.getTooltip(300.0f), ChangeStatsComponent.getTooltip()).setUnlockCheck(SulongAbility::canUnlock).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.BODY).setColor(COLOR).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("e158d542-5644-4921-9d5f-895f0b0a164c"), INSTANCE, "Sulong Speed Modifier", 1.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("00bd47ca-63b1-4040-b942-d9857231c9da"), INSTANCE, "Sulong Damage Modifier", 10.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("00bd47ca-63b1-4040-b942-d9857231c9da"), INSTANCE, "Sulong Jump Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier FALL_RESISTANCE = new AbilityAttributeModifier(UUID.fromString("00bd47ca-63b1-4040-b942-d9857231c9da"), INSTANCE, "Sulong Fall Resistance Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_HEIGHT = new AbilityAttributeModifier(UUID.fromString("eab680cd-a6dc-438a-99d8-46f9eb53a950"), INSTANCE, "Sulong Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public SulongAbility(AbilityCore<SulongAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.statsComponent, this.skinOverlayComponent);
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.PUNCH_DAMAGE.get(), (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.JUMP_HEIGHT.get(), (AttributeModifier)JUMP_MODIFIER);
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.FALL_RESISTANCE.get(), (AttributeModifier)FALL_RESISTANCE);
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.STEP_HEIGHT.get(), (AttributeModifier)STEP_HEIGHT);
        this.addCanUseCheck(ElectroHelper::canTransformInSulong);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 300.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.applyModifiers(entity);
        this.skinOverlayComponent.showAll(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
        this.skinOverlayComponent.hideAll(entity);
        float cooldown = Math.max(100.0f, this.continuousComponent.getContinueTime() * 2.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isMink() && props.getDoriki() >= 1200.0;
    }
}

