/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.sui.FreeSwimmingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class FishmanKarateHelper {
    public static boolean isInWater(LivingEntity entity) {
        boolean isInWater = entity.func_70090_H();
        boolean isFreeSwimming = false;
        IAbilityData props = AbilityDataCapability.get(entity);
        FreeSwimmingAbility freeSwimming = props.getEquippedAbility(FreeSwimmingAbility.INSTANCE);
        if (freeSwimming != null && freeSwimming.isContinuous() && freeSwimming.isSwimming()) {
            isFreeSwimming = true;
        }
        return isInWater || isFreeSwimming;
    }

    public static AbilityDescriptionLine.IDescriptionLine getWaterBuffedProjectileDamageStat(float waterMultiplier) {
        return (entity, ability) -> {
            AbilityProjectileEntity proj = ability.getComponent(ModAbilityKeys.PROJECTILE).map(comp -> comp.getCachedProjectile(entity)).orElse(null);
            if (proj != null && proj.getDamage() > 0.0f) {
                float waterDamage = proj.getDamage() * waterMultiplier;
                AbilityStat.Builder baseStatBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_BASE_DAMAGE, proj.getDamage());
                AbilityStat.Builder waterStatBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_WATER_DAMAGE, waterDamage);
                ability.getComponent(ModAbilityKeys.PROJECTILE).ifPresent(comp -> {
                    float baseBonus = comp.getDamageBonusManager().applyBonus(proj.getDamage()) - proj.getDamage();
                    AbilityStat.AbilityStatType bonusType = baseBonus > 0.0f ? AbilityStat.AbilityStatType.BUFF : (baseBonus < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                    baseStatBuilder.withBonus(baseBonus, bonusType);
                    float waterBonusDamage = comp.getDamageBonusManager().applyBonus(waterDamage) - waterDamage;
                    AbilityStat.AbilityStatType waterBonusType = waterBonusDamage > 0.0f ? AbilityStat.AbilityStatType.BUFF : (waterBonusDamage < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                    waterStatBuilder.withBonus(waterBonusDamage, waterBonusType);
                });
                ITextComponent baseStat = baseStatBuilder.build().getStatDescription(2);
                ITextComponent waterStat = waterStatBuilder.build().getStatDescription(2);
                StringBuilder sb = new StringBuilder();
                sb.append("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_PROJECTILE.getString() + "\u00a7r\n");
                sb.append(baseStat.getString() + "\n");
                sb.append(waterStat.getString());
                return new StringTextComponent(sb.toString());
            }
            return null;
        };
    }

    public static AbilityDescriptionLine.IDescriptionLine getWaterBuffedDamageStat(float normalDamage, float waterMultiplier) {
        return (entity, ability) -> {
            float waterDamage = normalDamage * waterMultiplier;
            AbilityStat.Builder baseStatBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_BASE_DAMAGE, normalDamage, normalDamage);
            AbilityStat.Builder waterStatBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_WATER_DAMAGE, waterDamage, waterDamage);
            ability.getComponent(ModAbilityKeys.DAMAGE).ifPresent(comp -> {
                float baseBonusDamage = comp.getBonusManager().applyBonus(normalDamage) - normalDamage;
                AbilityStat.AbilityStatType baseBonusType = baseBonusDamage > 0.0f ? AbilityStat.AbilityStatType.BUFF : (baseBonusDamage < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                baseStatBuilder.withBonus(baseBonusDamage, baseBonusType);
                float waterBonusDamage = comp.getBonusManager().applyBonus(waterDamage) - waterDamage;
                AbilityStat.AbilityStatType waterBonusType = waterBonusDamage > 0.0f ? AbilityStat.AbilityStatType.BUFF : (waterBonusDamage < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                waterStatBuilder.withBonus(waterBonusDamage, waterBonusType);
            });
            ITextComponent baseStat = baseStatBuilder.build().getStatDescription();
            ITextComponent waterStat = waterStatBuilder.build().getStatDescription();
            StringBuilder sb = new StringBuilder();
            sb.append(baseStat.getString() + "\n");
            sb.append(waterStat.getString());
            return new StringTextComponent(sb.toString());
        };
    }
}

