/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class FishmanPassiveBonusesAbility
extends PassiveStatBonusAbility {
    private static final AttributeModifier SWIM_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("d9a209e7-15c0-490e-a9b6-4470b0bf6d28"), "Fishman Swim Speed Multiplier", 3.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final Predicate<LivingEntity> FISHMAN_CHECK = entity -> {
        IDevilFruit fruitData = DevilFruitCapability.get(entity);
        return !entity.func_70090_H() || !fruitData.hasAnyDevilFruit() || entity.func_70644_a((Effect)ModEffects.BUBBLY_CORAL.get());
    };
    public static final AbilityCore<FishmanPassiveBonusesAbility> INSTANCE = new AbilityCore.Builder<FishmanPassiveBonusesAbility>("Fishman Passive Bonuses", AbilityCategory.RACIAL, AbilityType.PASSIVE, FishmanPassiveBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(ChangeStatsComponent.getTooltip()).setUnlockCheck(FishmanPassiveBonusesAbility::canUnlock).build();

    public FishmanPassiveBonusesAbility(AbilityCore<FishmanPassiveBonusesAbility> core) {
        super(core);
        this.pushStaticAttribute((Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_SPEED_MODIFIER);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    private void duringPassiveEvent(LivingEntity entity) {
        if (entity.func_208600_a((ITag)FluidTags.field_206959_a)) {
            entity.func_70050_g(300);
            entity.func_195064_c(new EffectInstance(Effects.field_76439_r, 250, 0, false, false));
            entity.func_195064_c(new EffectInstance(Effects.field_76422_e, 100, 0, false, false));
        }
    }

    @Override
    public Predicate<LivingEntity> getCheck() {
        return FISHMAN_CHECK;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get(entity);
        return props.isFishman();
    }
}

