/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class KachiageHaisokuAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kachiage_haisoku", new Pair[]{ImmutablePair.of((Object)"The user delivers a powerful kick to the opponent's chin, which is stronger inside water", null)});
    private static final float COOLDOWN = 160.0f;
    private static final float DAMAGE = 20.0f;
    private static final float WATER_DAMAGE_MUL = 2.0f;
    public static final AbilityCore<KachiageHaisokuAbility> INSTANCE = new AbilityCore.Builder<KachiageHaisokuAbility>("Kachiage Haisoku", AbilityCategory.RACIAL, KachiageHaisokuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ContinuousComponent.getTooltip(), FishmanKarateHelper.getWaterBuffedDamageStat(20.0f, 2.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(KachiageHaisokuAbility::canUnlock).build();
    private float damage = 20.0f;

    public KachiageHaisokuAbility(AbilityCore<KachiageHaisokuAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (FishmanKarateHelper.isInWater(entity)) {
            this.damage = 40.0f;
        }
        this.damage = 20.0f;
    }

    @Override
    public float getPunchDamage() {
        if (!this.isContinuous()) {
            return 20.0f;
        }
        return this.damage;
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchCooldown() {
        return 160.0f;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isFishman() && props.getDoriki() >= 1500.0;
    }
}

