/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MizuOsuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mizu_osu", new Pair[]{ImmutablePair.of((Object)"Spits water with enough force to push away any enemy in front of the user.", null)});
    private static final int COOLDOWN = 160;
    private static final float RANGE = 2.0f;
    public static final AbilityCore<MizuOsuAbility> INSTANCE = new AbilityCore.Builder<MizuOsuAbility>("Mizu Osu", AbilityCategory.RACIAL, MizuOsuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), RangeComponent.getTooltip(2.0f, RangeComponent.RangeType.LINE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public MizuOsuAbility(AbilityCore<MizuOsuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.5f, 2.0f);
        for (LivingEntity target : targets) {
            Vector3d diff = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_186678_a(4.0);
            target.func_213293_j(diff.field_72450_a, 0.2, diff.field_72449_c);
            target.field_70133_I = true;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.MIZU_OSU.get(), (Entity)entity, entity.func_226277_ct_(), 1.75 + entity.func_226278_cu_(), entity.func_226281_cx_());
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }
}

