/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.UchimizuProjectile;

public class UchimizuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "uchimizu", new Pair[]{ImmutablePair.of((Object)"The user hurls big and fast water droplets at the opponent", null)});
    private static final float COOLDOWN = 80.0f;
    private static final float WATER_DAMAGE_MUL = 2.0f;
    public static final AbilityCore<UchimizuAbility> INSTANCE = new AbilityCore.Builder<UchimizuAbility>("Uchimizu", AbilityCategory.RACIAL, UchimizuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f), FishmanKarateHelper.getWaterBuffedProjectileDamageStat(2.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.WATER).setUnlockCheck(UchimizuAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(100, this::onRepeaterTriggerEvent).addStopEvent(100, this::onRepeaterStopEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public UchimizuAbility(AbilityCore<UchimizuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.startContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 8, 2);
    }

    private void onRepeaterTriggerEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 1.2f);
    }

    private void onRepeaterStopEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 80.0f);
    }

    private UchimizuProjectile createProjectile(LivingEntity entity) {
        UchimizuProjectile proj = new UchimizuProjectile(entity.field_70170_p, entity);
        if (FishmanKarateHelper.isInWater(entity)) {
            proj.setDamage(proj.getDamage() * 2.0f);
        }
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isFishman() && props.getDoriki() >= 800.0;
    }
}

