/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.YarinamiProjectile;

public class YarinamiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "yarinami", new Pair[]{ImmutablePair.of((Object)"The user fires a densely compressed spear-shaped waterbullet at the opponent", null)});
    private static final float COOLDOWN = 240.0f;
    private static final float CHARGE_TIME = 60.0f;
    private static final float WATER_DAMAGE_MUL = 1.2f;
    public static final AbilityCore<YarinamiAbility> INSTANCE = new AbilityCore.Builder<YarinamiAbility>("Yarinami", AbilityCategory.RACIAL, YarinamiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(60.0f), FishmanKarateHelper.getWaterBuffedProjectileDamageStat(1.2f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.WATER).setUnlockCheck(YarinamiAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addEndEvent(100, this::onEndChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public YarinamiAbility(AbilityCore<YarinamiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void onEndChargeEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.5f, 0.0f);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private YarinamiProjectile createProjectile(LivingEntity entity) {
        YarinamiProjectile proj = new YarinamiProjectile(entity.field_70170_p, entity);
        if (FishmanKarateHelper.isInWater(entity)) {
            proj.setDamage(proj.getDamage() * 1.2f);
        }
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isFishman() && props.getDoriki() >= 5500.0;
    }
}

