/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gasu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gasu.ShinokuniAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.BigGastilleProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.GastilleProjectile;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class GastilleAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gastille", new Pair[]{ImmutablePair.of((Object)"Shoots a beam of lit gas from the users mouth, that explodes on impact", null), ImmutablePair.of((Object)"If %s is active a bigger and more destructive laser will be shot.", (Object)new Object[]{ShinokuniAbility.INSTANCE})});
    private static final int COOLDOWN = 140;
    public static final AbilityCore<GastilleAbility> INSTANCE = new AbilityCore.Builder<GastilleAbility>("Gastille", AbilityCategory.DEVIL_FRUITS, GastilleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.EXPLOSION).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public GastilleAbility(AbilityCore<GastilleAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        float projSpeed = 2.5f;
        if (((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(entity)) {
            projSpeed = 3.0f;
        }
        this.projectileComponent.shoot(entity, projSpeed, 1.0f);
        this.cooldownComponent.startCooldown(entity, 140.0f);
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        if (((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(entity)) {
            return new BigGastilleProjectile(entity.field_70170_p, entity);
        }
        return new GastilleProjectile(entity.field_70170_p, entity);
    }
}

