/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gasu;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KarakuniAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "karakuni", new Pair[]{ImmutablePair.of((Object)"Removes the oxygen around the user, suffocating and weakening everyone in the vicinity", null)});
    private static final UUID SHINOKUNI_RANGE_BONUS = UUID.fromString("05f3fc04-68e5-4f7b-a513-7237ad6fd643");
    private static final int COOLDOWN = 600;
    private static final int HOLD_TIME = 100;
    private static final int RANGE = 9;
    public static final AbilityCore<KarakuniAbility> INSTANCE = new AbilityCore.Builder<KarakuniAbility>("Karakuni", AbilityCategory.DEVIL_FRUITS, KarakuniAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f), ContinuousComponent.getTooltip(100.0f), RangeComponent.getTooltip(9.0f, RangeComponent.RangeType.AOE)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::stopContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private Interval suffocateInterval = new Interval(2);

    public KarakuniAbility(AbilityCore<KarakuniAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.suffocateInterval.canTick()) {
            this.rangeComponent.getBonusManager().removeBonus(SHINOKUNI_RANGE_BONUS);
            if (((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(entity)) {
                this.rangeComponent.getBonusManager().addBonus(SHINOKUNI_RANGE_BONUS, "Shinokuni Range Bonus", BonusOperation.ADD, 3.0f);
            }
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 9.0f);
            List<BlockPos> blocks = WyHelper.getNearbyBlocks((Entity)entity, 9);
            for (LivingEntity target : targets) {
                if (target.func_70648_aU()) continue;
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 500, 2, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76437_t, 500, 1, false, false));
                target.func_70050_g(target.func_70086_ai() - 50);
                int airLeft = target.func_70086_ai();
                if (airLeft <= 0) {
                    if (target.func_110143_aJ() > 8.0f) {
                        target.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(entity, this, "drown").setInternal(), 8.0f);
                    } else {
                        target.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 200, 1));
                    }
                }
                if (!target.func_70027_ad()) continue;
                target.func_70066_B();
            }
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
            BlockPos.Mutable blockUp = new BlockPos.Mutable();
            for (BlockPos blockPos : blocks) {
                blockUp.func_181079_c(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p());
                if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() != Blocks.field_150480_ab || entity.field_70170_p.func_180495_p((BlockPos)blockUp).func_177230_c() != Blocks.field_150350_a) continue;
                entity.field_70170_p.func_217377_a(blockPos, false);
            }
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }
}

