/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gasu;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShinokuniAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shinokuni", new Pair[]{ImmutablePair.of((Object)"Transforms into a gas giant releasing an area of effect gas near the user based on whatever %s the user holds when transforming.", (Object)new Object[]{Items.field_151068_bn})});
    private static final int HOLD_TIME = 600;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 300;
    public static final AbilityCore<ShinokuniAbility> INSTANCE = new AbilityCore.Builder<ShinokuniAbility>("Shinokuni", AbilityCategory.DEVIL_FRUITS, ShinokuniAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 300.0f), ContinuousComponent.getTooltip(600.0f), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Shinokuni Reach Modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Shinokuni Knockback Resistance Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Shinokuni Toughness Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier HEALTH_BOOST = new AbilityAttributeModifier(AttributeHelper.MORPH_HEALTH_UUID, INSTANCE, "Shinokuni Health Modifier", 20.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Shinokuni Strength Modifier", 7.0, AttributeModifier.Operation.ADDITION);
    public Potion effect;

    public ShinokuniAbility(AbilityCore<ShinokuniAbility> core) {
        super(core);
        Predicate<LivingEntity> isMorphed = entity -> this.morphComponent.isMorphed();
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233818_a_, (AttributeModifier)HEALTH_BOOST, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isMorphed);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addTickEvent(this::duringContinuityEvent);
        this.continuousComponent.addEndEvent(this::stopContinuityEvent);
    }

    public void startContinuityEvent(LivingEntity player, IAbility ability) {
        List<LivingEntity> list = WyHelper.getNearbyLiving(player.func_213303_ch(), (IWorld)player.field_70170_p, 20.0, ModEntityPredicates.getEnemyFactions(player));
        this.effect = PotionUtils.func_185191_c((ItemStack)player.func_184614_ca());
        if (!this.effect.equals(Potions.field_185229_a)) {
            player.func_184614_ca().func_190920_e(player.func_184614_ca().func_190916_E() - 1);
            list.forEach(target -> this.applyEffects(player, (LivingEntity)target));
        }
    }

    public void duringContinuityEvent(LivingEntity player, IAbility ability) {
        if (this.effect == null || this.effect.equals(Potions.field_185229_a)) {
            return;
        }
        if (this.continuousComponent.getContinueTime() % 100.0f == 0.0f) {
            List<LivingEntity> list = WyHelper.getNearbyLiving(player.func_213303_ch(), (IWorld)player.field_70170_p, 20.0, ModEntityPredicates.getEnemyFactions(player));
            for (LivingEntity target : list) {
                this.applyEffects(player, target);
            }
        }
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SHINOKUNI.get(), (Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        }
    }

    public void applyEffects(LivingEntity entity, LivingEntity target) {
        for (EffectInstance inst : this.effect.func_185170_a()) {
            boolean isAlly = ModEntityPredicates.getFriendlyFactions(entity).test((Entity)target);
            if (isAlly && inst.func_188419_a().func_188408_i()) {
                target.func_195064_c(new EffectInstance(inst.func_188419_a(), inst.func_76459_b(), inst.func_76458_c()));
            }
            if (isAlly || inst.func_188419_a().func_188408_i()) continue;
            target.func_195064_c(new EffectInstance(inst.func_188419_a(), inst.func_76459_b(), inst.func_76458_c()));
        }
    }

    protected void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        int cooldown = (int)(100L + Math.round((double)this.continuousComponent.getContinueTime() / 3.0));
        this.cooldownComponent.startCooldown(entity, cooldown);
        this.effect = null;
    }

    @Override
    public float getContinuityHoldTime() {
        return 600.0f;
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.SHINOKUNI.get();
    }
}

