/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import java.awt.Color;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoBazookaAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoGatlingAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuGomuNoPistolAbility;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GearSecondAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gear_second", new Pair[]{ImmutablePair.of((Object)"By speding up their blood flow, the user gains strength, speed and mobility.", null)});
    private static final int HOLD_TIME = 1000;
    private static final int MIN_COOLDOWN = 20;
    private static final float MAX_COOLDOWN = 666.6667f;
    public static final AbilityCore<GearSecondAbility> INSTANCE = new AbilityCore.Builder<GearSecondAbility>("Gear Second", AbilityCategory.DEVIL_FRUITS, GearSecondAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 666.6667f), ContinuousComponent.getTooltip(1000.0f), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.BODY).setColor(new Color(232, 54, 54, 74)).build();
    private static final AbilityAttributeModifier JUMP_HEIGHT = new AbilityAttributeModifier(UUID.fromString("a44a9644-369a-4e18-88d9-323727d3d85b"), INSTANCE, "Gear Second Jump Modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("a2337b58-7e6d-4361-a8ca-943feee4f906"), INSTANCE, "Gear Second Attack Damage Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("c495cf01-f3ff-4933-9805-5bb1ed9d27b0"), INSTANCE, "Gear Second Attack Speed Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_HEIGHT = new AbilityAttributeModifier(UUID.fromString("eab680cd-a6dc-438a-99d8-46f9eb53a950"), INSTANCE, "Gear Second Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private boolean prevSprintValue = false;

    public GearSecondAbility(AbilityCore<GearSecondAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.changeStatsComponent, this.skinOverlayComponent);
        this.changeStatsComponent.addAttributeModifier((Attribute)ModAttributes.JUMP_HEIGHT.get(), (AttributeModifier)JUMP_HEIGHT);
        this.changeStatsComponent.addAttributeModifier((Attribute)ModAttributes.STEP_HEIGHT.get(), (AttributeModifier)STEP_HEIGHT);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.addCanUseCheck(GomuHelper.canUseGearCheck(INSTANCE));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1000.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        GomuGomuNoBazookaAbility bazooka;
        GomuGomuNoGatlingAbility gatling;
        this.changeStatsComponent.applyModifiers(entity);
        this.skinOverlayComponent.showAll(entity);
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoPistolAbility pistol = props.getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE);
        if (pistol != null) {
            pistol.switchSecondGear(entity);
        }
        if ((gatling = props.getEquippedAbility(GomuGomuNoGatlingAbility.INSTANCE)) != null) {
            gatling.switchSecondGear(entity);
        }
        if ((bazooka = props.getEquippedAbility(GomuGomuNoBazookaAbility.INSTANCE)) != null) {
            bazooka.switchSecondGear(entity);
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GEAR_SECOND_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.prevSprintValue = entity.func_70051_ag();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 10.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GEAR_SECOND.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        if (!AbilityHelper.canUseMomentumAbilities(entity)) {
            return;
        }
        if (entity.func_70051_ag()) {
            if (!this.prevSprintValue) {
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            }
        } else {
            this.prevSprintValue = false;
            return;
        }
        float maxSpeed = 2.2f;
        Vector3d vec = entity.func_70040_Z();
        if (entity.func_233570_aj_()) {
            entity.func_213293_j(vec.field_72450_a * (double)maxSpeed, entity.func_213322_ci().field_72448_b, vec.field_72449_c * (double)maxSpeed);
        } else {
            entity.func_213293_j(vec.field_72450_a * (double)maxSpeed * 0.5, entity.func_213322_ci().field_72448_b, vec.field_72449_c * (double)maxSpeed * 0.5);
        }
        this.prevSprintValue = entity.func_70051_ag();
        entity.field_70133_I = true;
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        GomuGomuNoBazookaAbility bazooka;
        GomuGomuNoGatlingAbility gatling;
        this.changeStatsComponent.removeModifiers(entity);
        this.skinOverlayComponent.hideAll(entity);
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoPistolAbility pistol = props.getEquippedAbility(GomuGomuNoPistolAbility.INSTANCE);
        if (pistol != null) {
            pistol.switchNoGear(entity);
        }
        if ((gatling = props.getEquippedAbility(GomuGomuNoGatlingAbility.INSTANCE)) != null) {
            gatling.switchNoGear(entity);
        }
        if ((bazooka = props.getEquippedAbility(GomuGomuNoBazookaAbility.INSTANCE)) != null) {
            bazooka.switchNoGear(entity);
        }
        float cooldown = Math.max(20.0f, this.continuousComponent.getContinueTime() / 1.5f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

