/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoBajrangGunProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoElephantGunProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoJetPistolProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoKingKongGunProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoPistolProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class GomuGomuNoPistolAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gomu_gomu_no_pistol", new Pair[]{ImmutablePair.of((Object)"The user stretches their arm to punch the opponent.", null)});
    private static final TranslationTextComponent GOMU_GOMU_NO_PISTOL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_pistol", "Gomu Gomu no Pistol"));
    private static final TranslationTextComponent GOMU_GOMU_NO_JET_PISTOL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_jet_pistol", "Gomu Gomu no Jet Pistol"));
    private static final TranslationTextComponent GOMU_GOMU_NO_ELEPHANT_GUN_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_elephant_gun", "Gomu Gomu no Elephant Gun"));
    private static final TranslationTextComponent GOMU_GOMU_NO_KING_KONG_GUN_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_king_kong_gun", "Gomu Gomu no King Kong Gun"));
    private static final TranslationTextComponent GOMU_GOMU_NO_BAJRANG_GUN_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_bajrang_gun", "Gomu Gomu no Bajrang Gun"));
    private static final ResourceLocation GOMU_GOMU_NO_PISTOL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_pistol.png");
    private static final ResourceLocation GOMU_GOMU_NO_JET_PISTOL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_jet_pistol.png");
    private static final ResourceLocation GOMU_GOMU_NO_ELEPHANT_GUN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_elephant_gun.png");
    private static final ResourceLocation GOMU_GOMU_NO_KING_KONG_GUN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_king_kong_gun.png");
    private static final ResourceLocation GOMU_GOMU_NO_BAJRANG_GUN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_bajrang_gun.png");
    private static final int NO_GEAR_COOLDOWN = 30;
    private static final int SECOND_GEAR_COOLDOWN = 20;
    private static final int THIRD_GEAR_COOLDOWN = 120;
    private static final int FOURTH_GEAR_COOLDOWN = 80;
    private static final int FIFTH_GEAR_COOLDOWN = 100;
    private static final AbilityDescriptionLine.IDescriptionLine NO_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_PISTOL_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine SECOND_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_JET_PISTOL_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine THIRD_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_ELEPHANT_GUN_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine FOURTH_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_KING_KONG_GUN_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine FIFTH_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_BAJRANG_GUN_NAME));
    public static final AbilityCore<GomuGomuNoPistolAbility> INSTANCE = new AbilityCore.Builder<GomuGomuNoPistolAbility>("Gomu Gomu no Pistol", AbilityCategory.DEVIL_FRUITS, GomuGomuNoPistolAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, NO_GEAR_NAME_DESC, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(30.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, SECOND_GEAR_NAME_DESC, GomuHelper.SECOND_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, THIRD_GEAR_NAME_DESC, GomuHelper.THIRD_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, FOURTH_GEAR_NAME_DESC, GomuHelper.FOURTH_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AltModeComponent<GomuHelper.Gears> altModeComponent = new AltModeComponent<GomuHelper.Gears>(this, GomuHelper.Gears.class, GomuHelper.Gears.NO_GEAR, true).addChangeModeEvent(this::altModeChangeEvent);
    private float speed;
    private float cooldown = 30.0f;

    public GomuGomuNoPistolAbility(AbilityCore<GomuGomuNoPistolAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.altModeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, this.speed, 0.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GOMU_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, this.cooldown);
    }

    private void altModeChangeEvent(LivingEntity entity, IAbility ability, GomuHelper.Gears mode) {
        switch (mode) {
            case GEAR_2: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_JET_PISTOL_NAME);
                this.cooldown = 20.0f;
                break;
            }
            case GEAR_3: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_ELEPHANT_GUN_NAME);
                this.cooldown = 120.0f;
                break;
            }
            case GEAR_4: {
                this.setDisplayIcon(GOMU_GOMU_NO_KING_KONG_GUN_ICON);
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_KING_KONG_GUN_NAME);
                this.cooldown = 80.0f;
                break;
            }
            case GEAR_5: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_BAJRANG_GUN_NAME);
                this.cooldown = 100.0f;
                break;
            }
            default: {
                this.setDisplayIcon(GOMU_GOMU_NO_PISTOL_ICON);
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_PISTOL_NAME);
                this.cooldown = 30.0f;
            }
        }
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        IAbilityData props = AbilityDataCapability.get(entity);
        AbilityProjectileEntity projectile = null;
        this.speed = 2.0f;
        if (GomuHelper.hasGearFifthActive(props)) {
            projectile = new GomuGomuNoBajrangGunProjectile(entity.field_70170_p, entity, this);
            this.speed = 1.9f;
        } else if (GomuHelper.hasGearFourthActive(props)) {
            projectile = new GomuGomuNoKingKongGunProjectile(entity.field_70170_p, entity, this);
            this.speed = 1.8f;
        } else if (GomuHelper.hasGearThirdActive(props)) {
            projectile = new GomuGomuNoElephantGunProjectile(entity.field_70170_p, entity, this);
            this.speed = 1.8f;
        } else if (GomuHelper.hasGearSecondActive(props)) {
            projectile = new GomuGomuNoJetPistolProjectile(entity.field_70170_p, entity, this);
            projectile.setEntityCollisionSize(1.25);
            this.speed = 2.5f;
        } else {
            projectile = new GomuGomuNoPistolProjectile(entity.field_70170_p, entity);
            projectile.setEntityCollisionSize(1.25);
        }
        return projectile;
    }

    public void switchNoGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.NO_GEAR);
    }

    public void switchSecondGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_2);
    }

    public void switchThirdGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_3);
    }

    public void switchFourthGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_4);
    }

    public void switchFifthGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_5);
    }
}

