/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoRocketProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class GomuGomuNoRocketAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gomu_gomu_no_rocket", new Pair[]{ImmutablePair.of((Object)"Stretches towards a block, then launches the user on an arch depending on where they fist landed.", null)});
    private static final TranslationTextComponent GOMU_GOMU_NO_ROCKET_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_rocket", "Gomu Gomu no Rocket"));
    private static final TranslationTextComponent GOMU_GOMU_NO_DAWN_ROCKET_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_dawn_rocket", "Gomu Gomu no Dawn Rocket"));
    private static final ResourceLocation GOMU_GOMU_NO_ROCKET_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_rocket.png");
    private static final ResourceLocation GOMU_GOMU_NO_DAWN_ROCKET_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_dawn_rocket.png");
    private static final int COOLDOWN = 60;
    public static final AbilityCore<GomuGomuNoRocketAbility> INSTANCE = new AbilityCore.Builder<GomuGomuNoRocketAbility>("Gomu Gomu no Rocket", AbilityCategory.DEVIL_FRUITS, GomuGomuNoRocketAbility::new).addDescriptionLine(DESCRIPTION).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent(this).addSwingEvent(this::triggerSwingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AltModeComponent<GomuHelper.Gears> altModeComponent = new AltModeComponent<GomuHelper.Gears>(this, GomuHelper.Gears.class, GomuHelper.Gears.NO_GEAR, true).addChangeModeEvent(this::altModeChangeEvent);
    private int airTime = 0;

    public GomuGomuNoRocketAbility(AbilityCore<GomuGomuNoRocketAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.swingTriggerComponent, this.projectileComponent, this.altModeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.airTime = 0;
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_233570_aj_() && this.airTime < 10) {
            AbilityHelper.slowEntityFall(entity, 10);
            ++this.airTime;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }

    private void triggerSwingEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            return;
        }
        IAbilityData props = AbilityDataCapability.get(entity);
        float speed = GomuHelper.hasGearSecondActive(props) ? 4.0f : 3.125f;
        this.projectileComponent.shoot(entity, speed, 0.0f);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GOMU_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        this.continuousComponent.stopContinuity(entity);
    }

    private void altModeChangeEvent(LivingEntity entity, IAbility ability, GomuHelper.Gears mode) {
        switch (mode) {
            default: 
        }
        this.setDisplayIcon(GOMU_GOMU_NO_ROCKET_ICON);
        this.setDisplayName((ITextComponent)GOMU_GOMU_NO_ROCKET_NAME);
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        IAbilityData props = AbilityDataCapability.get(entity);
        GomuGomuNoRocketProjectile projectile = null;
        projectile = new GomuGomuNoRocketProjectile(entity.field_70170_p, entity, this);
        return projectile;
    }

    public void switchNoGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.NO_GEAR);
    }

    public void switchFifthGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_5);
    }
}

