/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElThorAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/el_thor.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/el_thor.png");
    public static final Color YELLOW_THUNDER = new Color(-135916, true);
    public static final Color BLUE_THUNDER = WyHelper.hexToRGB("#70EAFF22");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "el_thor", new Pair[]{ImmutablePair.of((Object)"Focuses a large cluster of electricity above the target, then sends a powerful lightning bolt crashing down from the sky", null)});
    private static final int CHARGE_TIME = 80;
    private static final int COOLDOWN = 360;
    public static final AbilityCore<ElThorAbility> INSTANCE = new AbilityCore.Builder<ElThorAbility>("El Thor", AbilityCategory.DEVIL_FRUITS, ElThorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(360.0f), ChargeComponent.getTooltip(80.0f)).setSourceElement(SourceElement.LIGHTNING).setSourceHakiNature(SourceHakiNature.SPECIAL).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, component -> component.getChargeTime() >= 10.0f).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final Interval particleInterval = new Interval(2);

    public ElThorAbility(AbilityCore<ElThorAbility> core) {
        super(core);
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.animationComponent);
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 80.0f);
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        AbilityHelper.slowEntityFall(entity);
        if (!this.particleInterval.canTick()) {
            return;
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 256.0, 0.4f);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        double particleAmount = this.chargeComponent.getChargeTime();
        int n = 0;
        while ((double)n < particleAmount) {
            double offsetX = WyHelper.randomDouble() * (double)n * 0.225;
            double offsetZ = WyHelper.randomDouble() * (double)n * 0.225;
            if (entity instanceof PlayerEntity) {
                WyHelper.spawnParticleEffectForOwner((ParticleEffect)ModParticleEffects.EL_THOR_AIM.get(), (PlayerEntity)entity, i + offsetX, j, k + offsetZ, null);
            }
            ++n;
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity);
        double time = this.chargeComponent.getChargePercentage();
        float multi = (float)((double)0.4f + time * (double)0.6f);
        if (((MorphInfo)ModMorphs.VOLT_AMARU.get()).isActive(entity)) {
            multi += 0.25f;
        }
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        float travelLength = 128.0f + 16.0f * multi;
        Vector3d pos = new Vector3d(i, j + 128.0, k);
        LightningEntity boltInner = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 90.0f, travelLength, 24.0f, this.getCore());
        LightningEntity boltOuter = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 90.0f, travelLength, 24.0f, this.getCore());
        this.setBoltPropieties(boltInner, 2.0f, 0.0f, 90, 40, false, Color.WHITE, multi);
        this.setBoltPropieties(boltOuter, 2.5f, 50.0f, 100, 9999, true, ClientConfig.INSTANCE.isGoroBlue() ? BLUE_THUNDER : YELLOW_THUNDER, multi);
        boltOuter.seed = boltInner.seed;
        entity.field_70170_p.func_217376_c((Entity)boltInner);
        entity.field_70170_p.func_217376_c((Entity)boltOuter);
        entity.field_70170_p.func_184133_a(null, new BlockPos(i, j, k), (SoundEvent)ModSounds.EL_THOR_SFX.get(), SoundCategory.PLAYERS, 20.0f, 1.0f);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 360.0f);
    }

    public void setBoltPropieties(LightningEntity bolt, float size, float damage, int timeAlive, int resetTime, boolean explodes, @Nullable Color color, float multiplier) {
        bolt.setBlocksAffectedLimit(8150);
        bolt.setAngle(160);
        bolt.setBranches(1);
        bolt.setSegments(1);
        bolt.setSize(size * multiplier);
        bolt.setBoxSizeDivision(0.225f);
        bolt.setLightningMovement(false);
        bolt.setExplosion(explodes ? (int)(10.0f * multiplier) : 0, true, 0.25f);
        if (color != null) {
            bolt.setColor(color);
        }
        bolt.setMaxLife(timeAlive);
        bolt.setDamage(damage * multiplier);
        bolt.setTargetTimeToReset(resetTime);
    }
}

