/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.awt.Color;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class VariAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/vari.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/vari.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "vari", new Pair[]{ImmutablePair.of((Object)"A basic move where the user discharges variable amounts of electricity", null)});
    private static final ITextComponent ONE_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.1_million_vari", "1 Million Vari"));
    private static final ITextComponent TWENTY_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.20_million_vari", "20 Million Vari"));
    private static final ITextComponent ONE_HUNDRED_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.100_million_vari", "100 Million Vari"));
    private static final ITextComponent TWO_HUNDRED_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.200_million_vari", "200 Million Vari"));
    private static final int CHARGE_TIME = 20;
    public static final AbilityCore<VariAbility> INSTANCE = new AbilityCore.Builder<VariAbility>("Vari", AbilityCategory.DEVIL_FRUITS, VariAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> ONE_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip(Mode.ONE_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip(20.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> TWENTY_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip(Mode.TWENTY_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip(20.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> ONE_HUNDRED_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip(Mode.ONE_HUNDRED_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip(20.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> TWO_HUNDRED_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip(Mode.TWO_HUNDRED_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, true).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.ONE_MILLION_V).addChangeModeEvent(this::onAltModeChange);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final Interval dischargeInterval = new Interval(5);

    public VariAbility(AbilityCore<VariAbility> core) {
        super(core);
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.altModeComponent, this.dealDamageComponent, this.animationComponent);
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.dischargeInterval.canTick()) {
            Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition(entity.func_213303_ch(), entity.field_70761_aq, 0.5, 1.15, 0.8);
            float multi = 1.0f;
            if (((MorphInfo)ModMorphs.VOLT_AMARU.get()).isActive(entity)) {
                multi += 0.25f;
            }
            LightningDischargeEntity discharge = new LightningDischargeEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            discharge.setAliveTicks(5);
            discharge.setLightningLength(0.2f * multi);
            discharge.setColor(Color.WHITE);
            discharge.setOutlineColor(ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER);
            discharge.setRenderTransparent();
            discharge.setDetails(20);
            discharge.setDensity(40);
            discharge.setSize(0.2f * multi);
            discharge.setSkipSegments(1);
            entity.field_70170_p.func_217376_c((Entity)discharge);
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        float multi = 1.0f;
        if (((MorphInfo)ModMorphs.VOLT_AMARU.get()).isActive(entity)) {
            multi += 0.25f;
        }
        ModDamageSource ablSource = AbilityDamageSource.causeAbilityDamage(entity, this.getCore()).setPiercing(0.75f).setUnavoidable();
        float radius = 12.0f * this.chargeComponent.getChargePercentage();
        Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition(entity.func_213303_ch(), entity.field_70761_aq, 0.5, 1.15, 0.8);
        LightningDischargeEntity discharge = new LightningDischargeEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
        discharge.setAliveTicks(15);
        discharge.setLightningLength(radius / 2.0f * multi);
        discharge.setColor(Color.WHITE);
        discharge.setOutlineColor(ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER);
        discharge.setRenderTransparent();
        discharge.setDetails(20);
        discharge.setDensity(40);
        discharge.setSize(radius / 2.0f * multi);
        discharge.setSkipSegments(1);
        entity.field_70170_p.func_217376_c((Entity)discharge);
        List<LivingEntity> targets = WyHelper.getNearbyEntities(pos, (IWorld)entity.field_70170_p, (double)radius, ModEntityPredicates.getEnemyFactions(entity), LivingEntity.class);
        targets.remove(entity);
        Mode currentMode = this.altModeComponent.getCurrentMode();
        for (LivingEntity target : targets) {
            float damage;
            if (!this.dealDamageComponent.hurtTarget(entity, target, (damage = (float)((double)(currentMode.getDamage() * this.chargeComponent.getChargePercentage()) * (1.0 - pos.func_72438_d(target.func_213303_ch()) / (double)(radius * 3.0f)))) * multi, ablSource)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 10, 0, false, false, true));
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, currentMode.getCooldown());
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        super.setDisplayName(mode.getDisplayName());
    }

    static /* synthetic */ ITextComponent access$000() {
        return ONE_MILLION_V_VARI_NAME;
    }

    static /* synthetic */ ITextComponent access$100() {
        return TWENTY_MILLION_V_VARI_NAME;
    }

    static /* synthetic */ ITextComponent access$200() {
        return ONE_HUNDRED_MILLION_V_VARI_NAME;
    }

    static /* synthetic */ ITextComponent access$300() {
        return TWO_HUNDRED_MILLION_V_VARI_NAME;
    }

    public static enum Mode {
        ONE_MILLION_V(VariAbility.access$000(), 10.0f, 200.0f),
        TWENTY_MILLION_V(VariAbility.access$100(), 35.0f, 300.0f),
        ONE_HUNDRED_MILLION_V(VariAbility.access$200(), 50.0f, 500.0f),
        TWO_HUNDRED_MILLION_V(VariAbility.access$300(), 65.0f, 600.0f);

        private ITextComponent displayName;
        private float damage;
        private float cooldown;

        private Mode(ITextComponent displayName, float damage, float cooldown) {
            this.displayName = displayName;
            this.damage = damage;
            this.cooldown = cooldown;
        }

        public ITextComponent getDisplayName() {
            return this.displayName;
        }

        public float getDamage() {
            return this.damage;
        }

        public float getCooldown() {
            return this.cooldown;
        }
    }
}

