/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.awt.Color;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.abilities.goro.VoltAmaruFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SRecalculateEyeHeightPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class VoltAmaruAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/volt_amaru.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/volt_amaru.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "volt_amaru", new Pair[]{ImmutablePair.of((Object)"Transforms the user into a powerful, lightning giant massively boosting physical attributes and lightning attacks", null)});
    private static final int COOLDOWN = 1000;
    private static final int CHARGE_TIME = 20;
    private static final int HOLD_TIME = 400;
    private static final Color COLOR = WyHelper.hexToRGB("#F0EC7155");
    public static final AbilityCore<VoltAmaruAbility> INSTANCE = new AbilityCore.Builder<VoltAmaruAbility>("Volt Amaru", AbilityCategory.DEVIL_FRUITS, VoltAmaruAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1000.0f), ChargeComponent.getTooltip(20.0f), ContinuousComponent.getTooltip(400.0f), ChangeStatsComponent.getTooltip()).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private final MorphComponent morphComponent = new MorphComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(100, this::onHitEvent);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Volt Amaru Reach Modifier", 4.8, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Volt Amaru Knockback Resistance Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Volt Amaru Toughness Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier HEALTH_BOOST = new AbilityAttributeModifier(AttributeHelper.MORPH_HEALTH_UUID, INSTANCE, "Volt Amaru Health Modifier", 20.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Volt Amaru Strength Modifier", 12.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Volt Amaru Attack Speed Modifier", 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityAttributeModifier JUMP_BOOST = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "Volt Amaru Jump Modifier", 5.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setColor(COLOR).setRenderType(AbilityOverlay.RenderType.ENERGY).build();
    private static final AbilityOverlay OVERLAY_ALT = new AbilityOverlay.Builder().setColor(ElThorAbility.BLUE_THUNDER).setRenderType(AbilityOverlay.RenderType.ENERGY).build();
    public float speed = 0.0f;

    public VoltAmaruAbility(AbilityCore<VoltAmaruAbility> core) {
        super(core);
        this.isNew = true;
        Predicate<LivingEntity> isMorphActive = entity -> this.morphComponent.isMorphed();
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isMorphActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isMorphActive);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233818_a_, (AttributeModifier)HEALTH_BOOST, isMorphActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isMorphActive);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER, isMorphActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_BOOST, isMorphActive);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isMorphActive);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE, isMorphActive);
        super.addComponents(this.chargeComponent, this.continuousComponent, this.changeStatsComponent, this.morphComponent, this.dealDamageComponent, this.hitTriggerComponent, this.skinOverlayComponent);
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
            this.skinOverlayComponent.removeOverlay(OVERLAY);
            this.skinOverlayComponent.addOverlay(OVERLAY_ALT);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
        LightningDischargeEntity ball = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        ball.setSize(4.0f);
        ball.setLightningLength(10.0f);
        ball.setAliveTicks(20);
        ball.setColor(ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER);
        entity.field_70170_p.func_217376_c((Entity)ball);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 1, false, false));
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 400.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        IAbilityData abilityDataProps;
        this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.VOLT_AMARU.get());
        this.changeStatsComponent.applyModifiers(entity);
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.Size((Entity)entity, entity.func_213283_Z(), entity.func_213305_a(entity.func_213283_Z()), entity.func_213302_cg()));
        entity.func_213323_x_();
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SRecalculateEyeHeightPacket(entity.func_145782_y()), entity);
        }
        if ((abilityDataProps = AbilityDataCapability.get(entity)) == null) {
            return;
        }
        PropelledFlightAbility voltAmaruFlightAbility = abilityDataProps.getPassiveAbility(VoltAmaruFlightAbility.INSTANCE);
        if (voltAmaruFlightAbility != null && !voltAmaruFlightAbility.isPaused()) {
            ((PlayerEntity)entity).field_71075_bZ.field_75100_b = true;
            PropelledFlightAbility.enableFlight((PlayerEntity)entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
        this.morphComponent.stopMorph(entity);
        this.changeStatsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, 1000.0f);
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        if (abilityDataProps == null) {
            return;
        }
        PropelledFlightAbility voltAmaruFlightAbility = abilityDataProps.getPassiveAbility(VoltAmaruFlightAbility.INSTANCE);
        if (voltAmaruFlightAbility != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)entity);
        }
    }

    private HitTriggerComponent.HitResult onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        float conductivity = ModTags.Items.CONDUCTIVE.getValue(entity.func_184614_ca().func_77973_b());
        if (conductivity > 0.5f) {
            AbilityHelper.setSecondsOnFireBy((Entity)target, 5, entity);
            this.dealDamageComponent.hurtTarget(entity, target, conductivity * 3.0f);
            return HitTriggerComponent.HitResult.HIT;
        }
        return HitTriggerComponent.HitResult.PASS;
    }
}

