/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.awt.Color;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BusoshokuHakiEmissionAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "busoshoku_haki_emission", new Pair[]{ImmutablePair.of((Object)"Allows the user to emit their haki over a short distance without a medium.", null)});
    public static final AbilityCore<BusoshokuHakiEmissionAbility> INSTANCE = new AbilityCore.Builder<BusoshokuHakiEmissionAbility>("Busoshoku Haki: Emission", AbilityCategory.HAKI, BusoshokuHakiEmissionAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(BusoshokuHakiEmissionAbility::canUnlock).setSourceType(SourceType.FIST).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setColor(new Color(226, 129, 25, 40)).build();
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.ADVANCED_BUSOSHOKU_HAKI, new AbilityPool2[0]);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public BusoshokuHakiEmissionAbility(AbilityCore<BusoshokuHakiEmissionAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart).addTickEvent(100, this::onContinuityTick).addEndEvent(100, this::onContinuityEnd);
        super.addComponents(this.poolComponent, this.skinOverlayComponent);
        super.addCanUseCheck(HakiHelper::canEnableHaki);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.ATTACK_RANGE, (AttributeModifier)HakiHelper.getAdvancedBusoshokuHakiAttackReachBonus(INSTANCE, BusoshokuHakiEmissionAbility.getReachBonus(entity)), this.canActivate());
        this.skinOverlayComponent.showAll(entity);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.BUSOSHOKU_HAKI_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(entity, 1);
        if (isOnMaxOveruse) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    public static float getReachBonus(LivingEntity player) {
        IHakiData hakiProps = HakiDataCapability.get(player);
        float hakiMultiplier = hakiProps.getBusoshokuHakiExp() / (float)CommonConfig.INSTANCE.getHakiExpLimit();
        return hakiMultiplier * 2.0f;
    }

    private static boolean canUnlock(LivingEntity user) {
        IAbilityData abilityProps = AbilityDataCapability.get(user);
        IHakiData props = HakiDataCapability.get(user);
        IEntityStats statsProps = EntityStatsCapability.get(user);
        boolean hasBusoUnlocked = abilityProps.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE) || abilityProps.hasUnlockedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        boolean hasBusoExp = (double)props.getBusoshokuHakiExp() > HakiHelper.getBusoshokuEmissionExpNeeded(user);
        return hasBusoUnlocked && statsProps.getDoriki() > 6000.0 && hasBusoExp;
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        source.bypassLogia();
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.EMISSION_BURST.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
        target.func_233627_a_(4.0f, entity.func_226277_ct_() - target.func_226277_ct_(), entity.func_226281_cx_() - target.func_226281_cx_());
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    @Override
    public int getUseLimit() {
        return -1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchCooldown() {
        return 0.0f;
    }
}

